/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.code;

import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.FormatBlock;
import org.xwiki.rendering.block.GroupBlock;
import org.xwiki.rendering.internal.code.layout.CodeLayoutHandler;
import org.xwiki.rendering.listener.Format;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.box.AbstractBoxMacro;
import org.xwiki.rendering.macro.code.CodeMacroParameters;
import org.xwiki.rendering.macro.descriptor.ContentDescriptor;
import org.xwiki.rendering.macro.descriptor.DefaultContentDescriptor;
import org.xwiki.rendering.parser.HighlightParser;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.transformation.MacroTransformationContext;

@Component
@Named(value="code")
@Singleton
public class CodeMacro
extends AbstractBoxMacro<CodeMacroParameters> {
    private static final String DESCRIPTION = "Highlights code snippets of various programming languages";
    private static final String LANGUAGE_NONE = "none";
    private static final String CONTENT_DESCRIPTION = "the content to highlight";
    @Inject
    @Named(value="plain/1.0")
    private Parser plainTextParser;
    @Inject
    private ComponentManager componentManager;
    @Inject
    private Logger logger;

    public CodeMacro() {
        super("Code", DESCRIPTION, (ContentDescriptor)new DefaultContentDescriptor(CONTENT_DESCRIPTION, false), CodeMacroParameters.class);
        this.setDefaultCategory("Formatting");
    }

    protected List<Block> parseContent(CodeMacroParameters parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        List<Object> result;
        try {
            result = LANGUAGE_NONE.equalsIgnoreCase(parameters.getLanguage()) ? (StringUtils.isEmpty((CharSequence)content) ? Collections.emptyList() : ((Block)this.plainTextParser.parse((Reader)new StringReader(content)).getChildren().get(0)).getChildren()) : this.highlight(parameters, content);
        }
        catch (Exception e) {
            throw new MacroExecutionException("Failed to highlight content", (Throwable)e);
        }
        LinkedHashMap<String, String> formatParameters = new LinkedHashMap<String, String>();
        formatParameters.put("class", "code");
        if (context.isInline()) {
            result = Arrays.asList(new FormatBlock((List)result, Format.NONE, formatParameters));
        } else {
            try {
                CodeLayoutHandler layoutHandler = (CodeLayoutHandler)this.componentManager.getInstance(CodeLayoutHandler.class, parameters.getLayout().getHint());
                result = layoutHandler.layout(result, content);
            }
            catch (ComponentLookupException e) {
                this.logger.error("Failed to load code layout handler for layout type [{}], no layout will be applied", (Object)parameters.getLayout().name(), (Object)e);
            }
            result = Arrays.asList(new GroupBlock(result, formatParameters));
        }
        return result;
    }

    protected List<Block> highlight(CodeMacroParameters parameters, String content) throws ParseException, ComponentLookupException {
        if (parameters.getLanguage() != null && this.componentManager.hasComponent(HighlightParser.class, parameters.getLanguage())) {
            try {
                HighlightParser parser = (HighlightParser)this.componentManager.getInstance(HighlightParser.class, parameters.getLanguage());
                return parser.highlight(parameters.getLanguage(), new StringReader(content));
            }
            catch (ComponentLookupException e) {
                this.logger.error("Faild to load highlighting parser for language [{}]", (Object)parameters.getLanguage(), (Object)e);
            }
        }
        this.logger.debug("Can't find any specific highlighting parser for language [{}]. Trying the default highlighting parser.", (Object)parameters.getLanguage());
        HighlightParser parser = (HighlightParser)this.componentManager.getInstance(HighlightParser.class, "default");
        return parser.highlight(parameters.getLanguage(), new StringReader(content));
    }
}

