/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.macro.container;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.GroupBlock;
import org.xwiki.rendering.macro.AbstractMacro;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.container.ContainerMacroParameters;
import org.xwiki.rendering.macro.container.LayoutManager;
import org.xwiki.rendering.macro.descriptor.ContentDescriptor;
import org.xwiki.rendering.transformation.MacroTransformationContext;

public abstract class AbstractContainerMacro<P extends ContainerMacroParameters>
extends AbstractMacro<P> {
    private static final String CLASS_ATTRIBUTE = "class";
    @Inject
    private ComponentManager componentManager;

    protected AbstractContainerMacro(String name, String description, ContentDescriptor contentDescriptor, Class<?> parametersBeanClass) {
        super(name, description, contentDescriptor, parametersBeanClass);
    }

    public List<Block> execute(P parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        HashMap<String, String> containerParameters = new HashMap<String, String>();
        if (((ContainerMacroParameters)parameters).isJustify()) {
            containerParameters.put(CLASS_ATTRIBUTE, "container-justified");
        }
        GroupBlock containerRoot = new GroupBlock(containerParameters);
        containerRoot.addChildren(this.getContent(parameters, content, context));
        LayoutManager layoutManager = this.getLayoutManager(((ContainerMacroParameters)parameters).getLayoutStyle());
        if (layoutManager != null) {
            layoutManager.layoutContainer((Block)containerRoot);
        }
        if (StringUtils.isNotEmpty((CharSequence)((ContainerMacroParameters)parameters).getCssClass())) {
            containerRoot.setParameter(CLASS_ATTRIBUTE, ((ContainerMacroParameters)parameters).getCssClass());
        }
        return Collections.singletonList(containerRoot);
    }

    protected LayoutManager getLayoutManager(String layoutStyle) {
        try {
            return (LayoutManager)this.getComponentManager().lookup(LayoutManager.class, layoutStyle);
        }
        catch (ComponentLookupException e) {
            return null;
        }
    }

    protected abstract List<Block> getContent(P var1, String var2, MacroTransformationContext var3) throws MacroExecutionException;

    protected ComponentManager getComponentManager() {
        return this.componentManager;
    }

    public boolean supportsInlineMode() {
        return false;
    }
}

