/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.include;

import java.util.List;
import java.util.Stack;
import javax.inject.Inject;
import javax.inject.Named;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.display.internal.DocumentDisplayer;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.rendering.block.HeaderBlock;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.block.SectionBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.macro.AbstractMacro;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.security.authorization.ContextualAuthorizationManager;

public abstract class AbstractIncludeMacro<P>
extends AbstractMacro<P> {
    @Inject
    protected DocumentAccessBridge documentAccessBridge;
    @Inject
    protected ContextualAuthorizationManager authorization;
    @Inject
    protected EntityReferenceSerializer<String> defaultEntityReferenceSerializer;
    @Inject
    @Named(value="configured")
    protected DocumentDisplayer documentDisplayer;
    @Inject
    @Named(value="macro")
    protected EntityReferenceResolver<String> macroEntityReferenceResolver;
    protected ThreadLocal<Stack<Object>> macrosBeingExecuted = new ThreadLocal();

    protected AbstractIncludeMacro(String name, String description, Class<?> parametersBeanClass) {
        super(name, description, parametersBeanClass);
    }

    public void setDocumentDisplayer(DocumentDisplayer documentDisplayer) {
        this.documentDisplayer = documentDisplayer;
    }

    protected void excludeFirstHeading(XDOM xdom) {
        xdom.getChildren().stream().findFirst().filter(block -> block instanceof SectionBlock).ifPresent(sectionBlock -> {
            List sectionChildren = sectionBlock.getChildren();
            sectionChildren.stream().findFirst().filter(block -> block instanceof HeaderBlock).ifPresent(headerBlock -> xdom.replaceChild(sectionChildren.subList(1, sectionChildren.size()), sectionBlock));
        });
    }

    protected EntityReference resolve(MacroBlock block, String reference, EntityType type, String messageText) throws MacroExecutionException {
        if (reference == null) {
            throw new MacroExecutionException(String.format("You must specify a 'reference' parameter pointing to the entity to %s.", messageText));
        }
        return this.macroEntityReferenceResolver.resolve((Object)reference, type, new Object[]{block});
    }

    protected void checkRecursion(EntityReference reference, String messageText) throws MacroExecutionException {
        Stack<Object> references = this.macrosBeingExecuted.get();
        if (references != null && references.contains(reference)) {
            throw new MacroExecutionException(String.format("Found recursive %s of document [%s]", messageText, reference));
        }
    }
}

