/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.rss;

import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang.StringUtils;
import org.xwiki.bridge.SkinAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.GroupBlock;
import org.xwiki.rendering.block.ImageBlock;
import org.xwiki.rendering.block.LinkBlock;
import org.xwiki.rendering.block.ParagraphBlock;
import org.xwiki.rendering.block.RawBlock;
import org.xwiki.rendering.internal.macro.rss.DefaultRomeFeedFactory;
import org.xwiki.rendering.internal.macro.rss.RomeFeedFactory;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.listener.reference.ResourceType;
import org.xwiki.rendering.macro.AbstractMacro;
import org.xwiki.rendering.macro.Macro;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.box.BoxMacroParameters;
import org.xwiki.rendering.macro.rss.RssMacroParameters;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.transformation.MacroTransformationContext;

@Component
@Named(value="rss")
@Singleton
public class RssMacro
extends AbstractMacro<RssMacroParameters> {
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String DESCRIPTION = "Output latest feed entries from a RSS feed.";
    private static final String FEED_ICON_RESOURCE_PATH = "icons/silk/feed.gif";
    @Inject
    @Named(value="box")
    protected Macro<BoxMacroParameters> boxMacro;
    @Inject
    private SkinAccessBridge skinAccessBridge;
    @Inject
    @Named(value="plain/1.0")
    private Parser plainTextParser;
    private RomeFeedFactory romeFeedFactory = new DefaultRomeFeedFactory();

    public RssMacro() {
        super("RSS", DESCRIPTION, RssMacroParameters.class);
        this.setDefaultCategory("Content");
    }

    public boolean supportsInlineMode() {
        return false;
    }

    public List<Block> execute(RssMacroParameters parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        SyndFeed feed = this.romeFeedFactory.createFeed(parameters);
        BoxMacroParameters boxParameters = new BoxMacroParameters();
        boolean hasImage = parameters.isImage() && feed.getImage() != null;
        boxParameters.setCssClass("rssfeed");
        if (!StringUtils.isEmpty((String)parameters.getWidth())) {
            boxParameters.setWidth(parameters.getWidth());
        }
        boxParameters.setBlockTitle(this.generateBoxTitle("rsschanneltitle", feed));
        if (hasImage) {
            boxParameters.setImage(new ResourceReference(feed.getImage().getUrl(), ResourceType.URL));
        }
        List result = this.boxMacro.execute((Object)boxParameters, content == null ? "" : content, context);
        this.generaterEntries((Block)result.get(0), feed, parameters, context);
        return result;
    }

    private List<? extends Block> generateBoxTitle(String cssClass, SyndFeed feed) {
        List<Block> titleBlocks;
        if (feed.getLink() == null) {
            titleBlocks = this.parsePlainText(feed.getTitle());
        } else {
            ResourceReference titleResourceReference = new ResourceReference(feed.getLink(), ResourceType.URL);
            LinkBlock titleTextLinkBlock = new LinkBlock(this.parsePlainText(feed.getTitle()), titleResourceReference, true);
            String imagePath = this.skinAccessBridge.getSkinFile(FEED_ICON_RESOURCE_PATH);
            ImageBlock imageBlock = new ImageBlock(new ResourceReference(imagePath, ResourceType.URL), false);
            LinkBlock titleImageLinkBlock = new LinkBlock(Arrays.asList(imageBlock), titleResourceReference, true);
            titleBlocks = Arrays.asList(titleTextLinkBlock, titleImageLinkBlock);
        }
        ParagraphBlock titleBlock = new ParagraphBlock(titleBlocks);
        titleBlock.setParameter(CLASS_ATTRIBUTE, cssClass);
        return Collections.singletonList(titleBlock);
    }

    private void generaterEntries(Block parentBlock, SyndFeed feed, RssMacroParameters parameters, MacroTransformationContext context) throws MacroExecutionException {
        int maxElements = parameters.getCount();
        int count = 0;
        for (Object item : feed.getEntries()) {
            if (++count > maxElements) break;
            SyndEntry entry = (SyndEntry)item;
            ResourceReference titleResourceReference = new ResourceReference(entry.getLink(), ResourceType.URL);
            LinkBlock titleBlock = new LinkBlock(this.parsePlainText(entry.getTitle()), titleResourceReference, true);
            ParagraphBlock paragraphTitleBlock = new ParagraphBlock(Collections.singletonList(titleBlock));
            paragraphTitleBlock.setParameter(CLASS_ATTRIBUTE, "rssitemtitle");
            parentBlock.addChild((Block)paragraphTitleBlock);
            if (!parameters.isContent() || entry.getDescription() == null) continue;
            RawBlock html = new RawBlock(entry.getDescription().getValue(), Syntax.XHTML_1_0);
            parentBlock.addChild((Block)new GroupBlock(Arrays.asList(html), Collections.singletonMap(CLASS_ATTRIBUTE, "rssitemdescription")));
        }
    }

    protected void setFeedFactory(RomeFeedFactory romeFeedFactory) {
        this.romeFeedFactory = romeFeedFactory;
    }

    private List<Block> parsePlainText(String content) {
        if (StringUtils.isEmpty((String)content)) {
            return Collections.emptyList();
        }
        try {
            return ((Block)this.plainTextParser.parse((Reader)new StringReader(content)).getChildren().get(0)).getChildren();
        }
        catch (ParseException e) {
            throw new RuntimeException("Failed to parse [" + content + "] as plain text", e);
        }
    }
}

