/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.script;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.StringTokenizer;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.classloader.ExtendedURLClassLoader;
import org.xwiki.classloader.ExtendedURLStreamHandler;
import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.internal.macro.script.AttachmentClassLoaderFactory;

@Component
@Singleton
public class DefaultAttachmentClassLoaderFactory
implements AttachmentClassLoaderFactory {
    private static final String ATTACHMENT_PREFIX = "attach:";
    @Inject
    private URLStreamHandlerFactory streamHandlerFactory;
    @Inject
    @Named(value="attachmentjar")
    private ExtendedURLStreamHandler attachmentJarHandler;

    @Override
    public ExtendedURLClassLoader createAttachmentClassLoader(String jarURLs, ClassLoader parent) throws Exception {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (URI uri : this.extractURIs(jarURLs)) {
            urls.add(new URL(null, uri.toString(), this.streamHandlerFactory.createURLStreamHandler(uri.getScheme())));
        }
        return new ExtendedURLClassLoader(urls.toArray(new URL[0]), parent, this.streamHandlerFactory);
    }

    @Override
    public void extendAttachmentClassLoader(String jarURLs, ExtendedURLClassLoader source) throws Exception {
        for (URI uri : this.extractURIs(jarURLs)) {
            if (uri.getScheme().equalsIgnoreCase(this.attachmentJarHandler.getProtocol())) {
                source.addURL(new URL(null, uri.toString(), this.streamHandlerFactory.createURLStreamHandler(uri.getScheme())));
                continue;
            }
            source.addURL(uri.toURL());
        }
    }

    private Set<URI> extractURIs(String jarURLs) throws URISyntaxException {
        LinkedHashSet<URI> uris = new LinkedHashSet<URI>();
        if (StringUtils.isNotEmpty((CharSequence)jarURLs)) {
            StringTokenizer tokenizer = new StringTokenizer(jarURLs, ",");
            while (tokenizer.hasMoreElements()) {
                String token = tokenizer.nextToken().trim();
                if (token.startsWith(ATTACHMENT_PREFIX)) {
                    uris.add(this.createURI(token));
                    continue;
                }
                uris.add(new URI(token));
            }
        }
        return uris;
    }

    private URI createURI(String attachmentReference) throws URISyntaxException {
        String uriBody = attachmentReference.substring(ATTACHMENT_PREFIX.length());
        try {
            uriBody = URLEncoder.encode(uriBody, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Failed to URL encode [" + uriBody + "] using UTF-8.", e);
        }
        return new URI(this.attachmentJarHandler.getProtocol() + "://" + uriBody);
    }
}

