/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.script;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.observation.event.CancelableEvent;
import org.xwiki.rendering.block.MacroMarkerBlock;
import org.xwiki.rendering.internal.macro.script.AbstractScriptCheckerListener;
import org.xwiki.rendering.internal.macro.script.NestedScriptMacroEnabled;
import org.xwiki.rendering.macro.Macro;
import org.xwiki.rendering.macro.MacroId;
import org.xwiki.rendering.macro.MacroLookupException;
import org.xwiki.rendering.macro.MacroManager;
import org.xwiki.rendering.macro.script.ScriptMacro;
import org.xwiki.rendering.macro.script.ScriptMacroParameters;
import org.xwiki.rendering.transformation.MacroTransformationContext;

@Component
@Named(value="nestedscriptmacrovalidator")
@Singleton
public class NestedScriptMacroValidatorListener
extends AbstractScriptCheckerListener {
    @Inject
    private MacroManager macroManager;

    public String getName() {
        return "nestedscriptmacrovalidator";
    }

    @Override
    protected void check(CancelableEvent event, MacroTransformationContext context, ScriptMacroParameters parameters) {
        if (context.getCurrentMacroBlock() != null) {
            for (MacroMarkerBlock parent = (MacroMarkerBlock)context.getCurrentMacroBlock().getParentBlockByType(MacroMarkerBlock.class); parent != null; parent = (MacroMarkerBlock)parent.getParentBlockByType(MacroMarkerBlock.class)) {
                String parentId = parent.getId();
                try {
                    Macro macro = this.macroManager.getMacro(new MacroId(parentId));
                    if (macro instanceof ScriptMacro) {
                        event.cancel("Nested scripts are not allowed");
                        continue;
                    }
                    if (macro instanceof NestedScriptMacroEnabled) {
                        return;
                    }
                    if (!"include".equals(parentId)) continue;
                    return;
                }
                catch (MacroLookupException exception) {
                    // empty catch block
                }
            }
        }
    }
}

