/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.macro.script;

import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.context.Execution;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.Event;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.macro.AbstractMacro;
import org.xwiki.rendering.macro.MacroContentParser;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.descriptor.ContentDescriptor;
import org.xwiki.rendering.macro.script.ScriptMacro;
import org.xwiki.rendering.macro.script.ScriptMacroParameters;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.transformation.MacroTransformationContext;
import org.xwiki.rendering.util.ParserUtils;
import org.xwiki.script.event.ScriptEvaluatedEvent;
import org.xwiki.script.event.ScriptEvaluatingEvent;

public abstract class AbstractScriptMacro<P extends ScriptMacroParameters>
extends AbstractMacro<P>
implements ScriptMacro {
    protected static final String CONTENT_DESCRIPTION = "the script to execute";
    @Inject
    @Deprecated
    protected DocumentAccessBridge documentAccessBridge;
    @Inject
    protected Execution execution;
    @Inject
    private ComponentManager componentManager;
    @Inject
    @Named(value="plain/1.0")
    private Parser plainTextParser;
    @Inject
    private MacroContentParser contentParser;
    @Inject
    private ObservationManager observation;
    private ParserUtils parserUtils = new ParserUtils();

    public AbstractScriptMacro(String macroName) {
        super(macroName, null, ScriptMacroParameters.class);
        this.setDefaultCategory("Development");
    }

    public AbstractScriptMacro(String macroName, String macroDescription) {
        super(macroName, macroDescription, ScriptMacroParameters.class);
        this.setDefaultCategory("Development");
    }

    public AbstractScriptMacro(String macroName, String macroDescription, ContentDescriptor contentDescriptor) {
        super(macroName, macroDescription, contentDescriptor, ScriptMacroParameters.class);
        this.setDefaultCategory("Development");
    }

    public AbstractScriptMacro(String macroName, String macroDescription, Class<? extends ScriptMacroParameters> parametersBeanClass) {
        super(macroName, macroDescription, parametersBeanClass);
        this.setDefaultCategory("Development");
    }

    public AbstractScriptMacro(String macroName, String macroDescription, ContentDescriptor contentDescriptor, Class<? extends ScriptMacroParameters> parametersBeanClass) {
        super(macroName, macroDescription, contentDescriptor, parametersBeanClass);
        this.setDefaultCategory("Development");
    }

    protected ComponentManager getComponentManager() {
        return this.componentManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Block> execute(P parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        List<Block> result = Collections.emptyList();
        if (StringUtils.isNotEmpty((CharSequence)content)) {
            try {
                ScriptEvaluatingEvent event = new ScriptEvaluatingEvent(this.getDescriptor().getId().getId());
                this.observation.notify((Event)event, (Object)context, parameters);
                if (event.isCanceled()) {
                    throw new MacroExecutionException(event.getReason());
                }
                List<Block> blocks = this.evaluateBlock(parameters, content, context);
                if (((ScriptMacroParameters)parameters).isOutput()) {
                    result = blocks;
                }
            }
            finally {
                this.observation.notify((Event)new ScriptEvaluatedEvent(this.getDescriptor().getId().getId()), (Object)context, parameters);
            }
        }
        return result;
    }

    protected List<Block> parseScriptResult(String content, P parameters, MacroTransformationContext context) throws MacroExecutionException {
        List result;
        if (((ScriptMacroParameters)parameters).isWiki()) {
            result = this.parseSourceSyntax(content, context);
        } else {
            try {
                result = this.plainTextParser.parse((Reader)new StringReader(content)).getChildren();
            }
            catch (ParseException e) {
                throw new MacroExecutionException("Failed to parse link label as plain text", (Throwable)e);
            }
        }
        if (context.isInline()) {
            this.parserUtils.removeTopLevelParagraph(result);
            if (!result.isEmpty() && result.get(0) instanceof MacroBlock && !((MacroBlock)result.get(0)).isInline()) {
                MacroBlock macro = (MacroBlock)result.get(0);
                result.set(0, new MacroBlock(macro.getId(), macro.getParameters(), macro.getContent(), true));
            }
        }
        return result;
    }

    @Deprecated
    protected String evaluate(P parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        return "";
    }

    protected String evaluateString(P parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        return this.evaluate(parameters, content, context);
    }

    protected List<Block> evaluateBlock(P parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        String scriptResult = this.evaluateString(parameters, content, context);
        List<Block> result = Collections.emptyList();
        if (((ScriptMacroParameters)parameters).isOutput()) {
            result = this.parseScriptResult(scriptResult, parameters, context);
        }
        return result;
    }

    protected List<Block> parseSourceSyntax(String content, MacroTransformationContext context) throws MacroExecutionException {
        return this.contentParser.parse(content, context, false, false).getChildren();
    }
}

