/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.velocity.filter;

import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.velocity.VelocityContext;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.rendering.macro.velocity.filter.VelocityMacroFilter;
import org.xwiki.velocity.internal.util.InvalidVelocityException;
import org.xwiki.velocity.internal.util.VelocityBlock;
import org.xwiki.velocity.internal.util.VelocityParser;
import org.xwiki.velocity.internal.util.VelocityParserContext;

@Component
@Named(value="html")
@Singleton
public class HTMLVelocityMacroFilter
implements VelocityMacroFilter,
Initializable {
    private static final String BINDING_NEWLINE = "nl";
    private static final String NEWLINE = "\n";
    private static final String BINDING_SPACE = "sp";
    private static final String SPACE = " ";
    private static final Pattern MSNEWLINE_PATTERN = Pattern.compile("\\r\\n|\\r");
    @Inject
    private Logger logger;
    private VelocityParser velocityParser;

    public void initialize() throws InitializationException {
        this.velocityParser = new VelocityParser();
    }

    @Override
    public String before(String content, VelocityContext velocityContext) {
        velocityContext.put(BINDING_NEWLINE, (Object)NEWLINE);
        velocityContext.put(BINDING_SPACE, (Object)SPACE);
        return this.clean(content);
    }

    public String clean(String content) {
        StringBuffer contentBuffer = new StringBuffer();
        char[] array = MSNEWLINE_PATTERN.matcher(content).replaceAll(NEWLINE).toCharArray();
        VelocityParserContext context = new VelocityParserContext();
        FilterContext filterContext = new FilterContext();
        int i = 0;
        while (i < array.length) {
            try {
                if (array[i] == '#') {
                    i = this.cleanKeyWord(contentBuffer, array, i, context, filterContext);
                    continue;
                }
                if (array[i] == '$') {
                    i = this.cleanVar(contentBuffer, array, i, context, filterContext);
                    continue;
                }
                if (Character.isWhitespace(array[i])) {
                    if (!filterContext.removeWhiteSpaces && contentBuffer.length() > 0) {
                        filterContext.foundWhiteSpace = true;
                    }
                    ++i;
                    continue;
                }
            }
            catch (InvalidVelocityException e) {
                this.logger.debug("Not a valid velocity keyword at char [" + i + "]", (Throwable)e);
            }
            this.flushWhiteSpaces(contentBuffer, filterContext, false);
            contentBuffer.append(array[i]);
            ++i;
        }
        this.flushWhiteSpaces(contentBuffer, filterContext, true);
        return contentBuffer.toString();
    }

    private int cleanKeyWord(StringBuffer contentBuffer, char[] array, int currentIndex, VelocityParserContext context, FilterContext filterContext) throws InvalidVelocityException {
        int i = this.velocityParser.getKeyWord(array, currentIndex, null, context);
        if (context.getType() != VelocityBlock.VelocityType.COMMENT) {
            if (context.getType() == VelocityBlock.VelocityType.DIRECTIVE) {
                if (filterContext.wsGroup.length() == 0) {
                    this.flushWhiteSpaces(filterContext.wsGroup, filterContext, false);
                }
                filterContext.wsGroup.append(array, currentIndex, i - currentIndex);
                filterContext.removeWhiteSpaces = true;
            } else {
                this.flushWhiteSpaces(contentBuffer, filterContext, false);
                contentBuffer.append(array, currentIndex, i - currentIndex);
            }
        }
        return i;
    }

    private int cleanVar(StringBuffer contentBuffer, char[] array, int currentIndex, VelocityParserContext context, FilterContext filterContext) throws InvalidVelocityException {
        StringBuffer varName = new StringBuffer();
        int i = this.velocityParser.getVar(array, currentIndex, varName, null, context);
        if (varName.toString().equals(BINDING_NEWLINE)) {
            this.flushWhiteSpaces(contentBuffer, filterContext, true);
            contentBuffer.append("${nl}");
            filterContext.removeWhiteSpaces = true;
        } else {
            this.flushWhiteSpaces(contentBuffer, filterContext, false);
            contentBuffer.append(array, currentIndex, i - currentIndex);
        }
        return i;
    }

    private void flushWhiteSpaces(StringBuffer contentBuffer, FilterContext filterContext, boolean forceNoSpace) {
        if (filterContext.wsGroup.length() > 0) {
            boolean space;
            boolean bl = space = filterContext.wsGroup.charAt(0) == ' ';
            if (forceNoSpace && space) {
                contentBuffer.append(filterContext.wsGroup, 1, filterContext.wsGroup.length());
            } else {
                contentBuffer.append(filterContext.wsGroup);
            }
            filterContext.wsGroup.setLength(0);
        }
        if (filterContext.foundWhiteSpace && !forceNoSpace) {
            contentBuffer.append(' ');
        }
        filterContext.foundWhiteSpace = false;
        filterContext.removeWhiteSpaces = false;
    }

    @Override
    public String after(String content, VelocityContext velocityContext) {
        velocityContext.remove(BINDING_NEWLINE);
        velocityContext.remove(BINDING_SPACE);
        return content;
    }

    static class FilterContext {
        private boolean foundWhiteSpace;
        private boolean removeWhiteSpaces;
        private StringBuffer wsGroup = new StringBuffer();

        FilterContext() {
        }

        public boolean isFoundWhiteSpace() {
            return this.foundWhiteSpace;
        }

        public void setFoundWhiteSpace(boolean foundWhiteSpace) {
            this.foundWhiteSpace = foundWhiteSpace;
        }

        public boolean isRemoveWhiteSpaces() {
            return this.removeWhiteSpaces;
        }

        public void setRemoveWhiteSpaces(boolean removeWhiteSpaces) {
            this.removeWhiteSpaces = removeWhiteSpaces;
        }

        public StringBuffer getWsGroup() {
            return this.wsGroup;
        }
    }
}

