/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.executor;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.executor.ContentExecutor;
import org.xwiki.rendering.executor.ContentExecutorException;
import org.xwiki.rendering.parser.ContentParser;
import org.xwiki.rendering.parser.MissingParserException;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.transformation.MacroTransformationContext;
import org.xwiki.rendering.transformation.Transformation;
import org.xwiki.rendering.transformation.TransformationException;

@Component
@Singleton
public class MacroContentExecutor
implements ContentExecutor<MacroTransformationContext> {
    @Inject
    private ContentParser contentParser;
    @Inject
    @Named(value="macro")
    private Transformation macroTransformation;

    @Override
    public XDOM execute(String content, Syntax syntax, MacroTransformationContext macroContext) throws ParseException, MissingParserException, ContentExecutorException {
        XDOM xdom = this.contentParser.parse(content, syntax);
        this.executeContent(xdom, macroContext);
        return xdom;
    }

    @Override
    public XDOM execute(String content, Syntax syntax, EntityReference source, MacroTransformationContext macroContext) throws ParseException, MissingParserException, ContentExecutorException {
        XDOM xdom = this.contentParser.parse(content, syntax, source);
        this.executeContent(xdom, macroContext);
        return xdom;
    }

    private void executeContent(XDOM xdom, MacroTransformationContext macroContext) throws ContentExecutorException {
        try {
            this.macroTransformation.transform((Block)xdom, macroContext.getTransformationContext());
        }
        catch (TransformationException e) {
            throw new ContentExecutorException("Failed to execute content", e);
        }
    }
}

