/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.macro;

import java.io.IOException;
import java.lang.reflect.Type;
import java.security.GeneralSecurityException;
import javax.inject.Inject;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.crypto.pkix.CertificateProvider;
import org.xwiki.crypto.signer.param.CMSSignedDataGeneratorParameters;
import org.xwiki.crypto.signer.param.CMSSignedDataVerified;
import org.xwiki.crypto.store.SignatureStore;
import org.xwiki.crypto.store.SignatureStoreException;
import org.xwiki.model.reference.BlockReference;
import org.xwiki.model.reference.BlockReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.macro.AbstractMacro;
import org.xwiki.rendering.macro.MacroSignatureException;
import org.xwiki.rendering.macro.SignableMacro;
import org.xwiki.rendering.macro.descriptor.ContentDescriptor;
import org.xwiki.rendering.signature.BlockSignatureGenerator;
import org.xwiki.rendering.signature.BlockSignatureVerifier;

public abstract class AbstractSignableMacro<P>
extends AbstractMacro<P>
implements SignableMacro {
    private static final String HINT = "macro";
    @Inject
    private ComponentManager componentManager;
    private SignatureStore signatureStore;
    private BlockSignatureGenerator signer;
    private BlockSignatureVerifier verifier;
    private BlockReferenceResolver<Block> blockResolver;

    public AbstractSignableMacro(String name) {
        super(name);
    }

    public AbstractSignableMacro(String name, String description) {
        super(name, description);
    }

    public AbstractSignableMacro(String name, String description, ContentDescriptor contentDescriptor) {
        super(name, description, contentDescriptor);
    }

    public AbstractSignableMacro(String name, String description, Class<?> parametersBeanClass) {
        super(name, description, parametersBeanClass);
    }

    public AbstractSignableMacro(String name, String description, ContentDescriptor contentDescriptor, Class<?> parametersBeanClass) {
        super(name, description, contentDescriptor, parametersBeanClass);
    }

    protected ComponentManager getComponentManager() {
        return this.componentManager;
    }

    private SignatureStore getSignatureStore() throws ComponentLookupException {
        if (this.signatureStore == null) {
            this.signatureStore = (SignatureStore)this.getComponentManager().getInstance(SignatureStore.class);
        }
        return this.signatureStore;
    }

    private BlockSignatureGenerator getSigner() throws ComponentLookupException {
        if (this.signer == null) {
            this.signer = (BlockSignatureGenerator)this.getComponentManager().getInstance(BlockSignatureGenerator.class, HINT);
        }
        return this.signer;
    }

    private BlockSignatureVerifier getVerifier() throws ComponentLookupException {
        if (this.verifier == null) {
            this.verifier = (BlockSignatureVerifier)this.getComponentManager().getInstance(BlockSignatureVerifier.class, HINT);
        }
        return this.verifier;
    }

    private BlockReferenceResolver<Block> getBlockResolver() throws ComponentLookupException {
        if (this.blockResolver == null) {
            this.blockResolver = (BlockReferenceResolver)this.getComponentManager().getInstance((Type)new DefaultParameterizedType(null, BlockReferenceResolver.class, new Type[]{Block.class}), "currentsignedmacro");
        }
        return this.blockResolver;
    }

    @Override
    public void sign(Block block, CMSSignedDataGeneratorParameters parameters) throws MacroSignatureException {
        EntityReference blockRef = this.getBlockReference(block);
        try {
            this.getSignatureStore().store(blockRef, this.getSigner().generate(block, parameters));
        }
        catch (SignatureStoreException e) {
            throw new MacroSignatureException(String.format("Unable to store the signature of macro block [%s].", blockRef), e);
        }
        catch (GeneralSecurityException e) {
            throw new MacroSignatureException(String.format("Unable to compute signature of macro block [%s].", blockRef), e);
        }
        catch (IOException e) {
            throw new MacroSignatureException(String.format("Unable to encode signature of macro block [%s].", blockRef), e);
        }
        catch (ComponentLookupException e) {
            throw new MacroSignatureException(String.format("Missing components to sign macro block [%s].", blockRef), e);
        }
    }

    @Override
    public CMSSignedDataVerified verify(Block block, CertificateProvider certificateProvider) throws MacroSignatureException {
        EntityReference blockRef = this.getBlockReference(block);
        try {
            return this.getVerifier().verify(this.getSignatureStore().retrieve(blockRef), block, certificateProvider);
        }
        catch (SignatureStoreException e) {
            throw new MacroSignatureException(String.format("Unable to retrieve the signature of macro block [%s].", blockRef), e);
        }
        catch (GeneralSecurityException e) {
            throw new MacroSignatureException(String.format("Unable to verify signature of macro block [%s].", blockRef), e);
        }
        catch (IOException e) {
            throw new MacroSignatureException(String.format("Unable to decode signature of macro block [%s].", blockRef), e);
        }
        catch (ComponentLookupException e) {
            throw new MacroSignatureException(String.format("Missing components to verify macro block [%s].", blockRef), e);
        }
    }

    private EntityReference getBlockReference(Block block) throws MacroSignatureException {
        BlockReference blockRef;
        try {
            blockRef = this.getBlockResolver().resolve((Object)block, new Object[0]);
        }
        catch (ComponentLookupException e) {
            throw new MacroSignatureException("Missing component to resolve macro block reference.", e);
        }
        if (blockRef == null) {
            throw new MacroSignatureException("Unable to determine the block reference of the macro block.");
        }
        return blockRef;
    }
}

