/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.signature.internal;

import java.io.IOException;
import java.security.GeneralSecurityException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.crypto.signer.CMSSignedDataGenerator;
import org.xwiki.crypto.signer.param.CMSSignedDataGeneratorParameters;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.block.MacroMarkerBlock;
import org.xwiki.rendering.signature.BlockSignatureGenerator;
import org.xwiki.rendering.signature.internal.BlockDumper;

@Component
@Named(value="macro")
@Singleton
public class MacroBlockSignatureGenerator
implements BlockSignatureGenerator {
    @Inject
    @Named(value="macro")
    private BlockDumper dumper;
    @Inject
    private CMSSignedDataGenerator generator;

    @Override
    public byte[] generate(Block block, CMSSignedDataGeneratorParameters params) throws GeneralSecurityException, IOException {
        if (!this.isSupported(block)) {
            throw new IllegalArgumentException("Unsupported block [" + block.getClass().getName() + "].");
        }
        return this.generator.generate(this.dumper.dump(block), params);
    }

    @Override
    public boolean isSupported(Block block) {
        return block instanceof MacroBlock || block instanceof MacroMarkerBlock;
    }
}

