/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.model.reference.internal;

import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.crypto.BinaryStringEncoder;
import org.xwiki.crypto.Digest;
import org.xwiki.crypto.DigestFactory;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.BlockReference;
import org.xwiki.model.reference.BlockReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.signature.internal.BlockDumper;

@Component
@Named(value="signedmacro")
@Singleton
public class SignedMacroBlockReferenceResolver
implements BlockReferenceResolver<Block> {
    @Inject
    @Named(value="SHA-1")
    private DigestFactory digestFactory;
    @Inject
    @Named(value="Base64")
    private BinaryStringEncoder encoder;
    @Inject
    @Named(value="macro")
    private BlockDumper dumper;

    public BlockReference resolve(Block block, Object ... parameters) {
        EntityReference parent = null;
        if (parameters.length > 0 && parameters[0] instanceof EntityReference) {
            parent = (EntityReference)parameters[0];
        }
        Digest digest = this.digestFactory.getInstance();
        try {
            this.dumper.dump(digest.getOutputStream(), block);
            return new BlockReference(new EntityReference(this.encoder.encode(digest.digest()), EntityType.BLOCK, parent));
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

