/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.scripting;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.renderer.PrintRendererFactory;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.script.service.ScriptService;

@Component
@Named(value="rendering")
@Singleton
public class RenderingScriptService
implements ScriptService {
    @Inject
    private ComponentManager componentManager;

    public List<Syntax> getAvailableParserSyntaxes() {
        ArrayList<Syntax> syntaxes = new ArrayList<Syntax>();
        try {
            for (Parser parser : this.componentManager.lookupList(Parser.class)) {
                syntaxes.add(parser.getSyntax());
            }
        }
        catch (ComponentLookupException componentLookupException) {
            // empty catch block
        }
        return syntaxes;
    }

    public List<Syntax> getAvailableRendererSyntaxes() {
        ArrayList<Syntax> syntaxes = new ArrayList<Syntax>();
        try {
            for (PrintRendererFactory factory : this.componentManager.lookupList(PrintRendererFactory.class)) {
                syntaxes.add(factory.getSyntax());
            }
        }
        catch (ComponentLookupException componentLookupException) {
            // empty catch block
        }
        return syntaxes;
    }
}

