/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.script;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.configuration.RenderingConfiguration;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.renderer.BlockRenderer;
import org.xwiki.rendering.renderer.PrintRendererFactory;
import org.xwiki.rendering.renderer.printer.DefaultWikiPrinter;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.syntax.SyntaxFactory;
import org.xwiki.script.service.ScriptService;

@Component
@Named(value="rendering")
@Singleton
public class RenderingScriptService
implements ScriptService {
    @Inject
    private ComponentManager componentManager;
    @Inject
    private RenderingConfiguration configuration;
    @Inject
    private SyntaxFactory syntaxFactory;

    public List<Syntax> getAvailableParserSyntaxes() {
        ArrayList<Syntax> syntaxes = new ArrayList<Syntax>();
        try {
            for (Parser parser : this.componentManager.getInstanceList(Parser.class)) {
                syntaxes.add(parser.getSyntax());
            }
        }
        catch (ComponentLookupException componentLookupException) {
            // empty catch block
        }
        return syntaxes;
    }

    public List<Syntax> getAvailableRendererSyntaxes() {
        ArrayList<Syntax> syntaxes = new ArrayList<Syntax>();
        try {
            List factories = this.componentManager.getInstanceList(PrintRendererFactory.class);
            for (PrintRendererFactory factory : factories) {
                syntaxes.add(factory.getSyntax());
            }
        }
        catch (ComponentLookupException componentLookupException) {
            // empty catch block
        }
        return syntaxes;
    }

    public List<String> getDefaultTransformationNames() {
        return this.configuration.getTransformationNames();
    }

    public XDOM parse(String text, String syntaxId) {
        XDOM result;
        try {
            Parser parser = (Parser)this.componentManager.getInstance(Parser.class, syntaxId);
            result = parser.parse((Reader)new StringReader(text));
        }
        catch (Exception e) {
            result = null;
        }
        return result;
    }

    public String render(Block block, String outputSyntaxId) {
        String result;
        DefaultWikiPrinter printer = new DefaultWikiPrinter();
        try {
            BlockRenderer renderer = (BlockRenderer)this.componentManager.getInstance(BlockRenderer.class, outputSyntaxId);
            renderer.render(block, (WikiPrinter)printer);
            result = printer.toString();
        }
        catch (Exception e) {
            result = null;
        }
        return result;
    }

    public Syntax resolveSyntax(String syntaxId) {
        Syntax syntax;
        try {
            syntax = this.syntaxFactory.createSyntaxFromIdString(syntaxId);
        }
        catch (ParseException exception) {
            syntax = null;
        }
        return syntax;
    }
}

