/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.wiki;

import com.steadystate.css.parser.CSSOMParser;
import com.steadystate.css.parser.SACParserCSS21;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.Parser;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.bridge.SkinAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.AttachmentReference;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.rendering.internal.configuration.XWikiRenderingConfiguration;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.listener.reference.ResourceType;
import org.xwiki.rendering.wiki.WikiModel;

@Component
@Singleton
public class XWikiWikiModel
implements WikiModel {
    private static final String PIXELS = "px";
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    private static final Charset UTF8 = Charset.forName("UTF-8");
    @Inject
    private XWikiRenderingConfiguration xwikiRenderingConfiguration;
    @Inject
    private DocumentAccessBridge documentAccessBridge;
    @Inject
    private SkinAccessBridge skinAccessBridge;
    @Inject
    @Named(value="compactwiki")
    private EntityReferenceSerializer<String> compactEntityReferenceSerializer;
    @Inject
    private EntityReferenceResolver<ResourceReference> resourceReferenceEntityReferenceResolver;
    @Inject
    private Logger logger;
    private final CSSOMParser cssParser = new CSSOMParser((Parser)new SACParserCSS21());

    public String getLinkURL(ResourceReference linkReference) {
        EntityReference attachmentReference = this.resourceReferenceEntityReferenceResolver.resolve((Object)linkReference, EntityType.ATTACHMENT, new Object[0]);
        if (attachmentReference == null) {
            throw new IllegalArgumentException(String.valueOf(attachmentReference));
        }
        return this.documentAccessBridge.getAttachmentURL(new AttachmentReference(attachmentReference), linkReference.getParameter("queryString"), false);
    }

    public String getImageURL(ResourceReference imageReference, Map<String, String> parameters) {
        Map<String, Object> urlParameters;
        if (imageReference.getType().equals((Object)ResourceType.ICON)) {
            return this.skinAccessBridge.getIconURL(imageReference.getReference());
        }
        if (this.xwikiRenderingConfiguration.isImageDimensionsIncludedInImageURL() && !(urlParameters = this.getImageURLParameters(parameters)).isEmpty()) {
            String queryString = imageReference.getParameter("queryString");
            queryString = this.extendQueryString(queryString, urlParameters);
            ResourceReference scaledImageReference = imageReference.clone();
            scaledImageReference.setParameter("queryString", queryString);
            return this.getLinkURL(scaledImageReference);
        }
        return this.getLinkURL(imageReference);
    }

    public boolean isDocumentAvailable(ResourceReference resourceReference) {
        EntityReference documentReference = this.resourceReferenceEntityReferenceResolver.resolve((Object)resourceReference, EntityType.DOCUMENT, new Object[0]);
        if (documentReference == null) {
            throw new IllegalArgumentException(String.valueOf(resourceReference));
        }
        return this.documentAccessBridge.exists(new DocumentReference(documentReference));
    }

    public String getDocumentViewURL(ResourceReference resourceReference) {
        EntityReference documentReference = this.resourceReferenceEntityReferenceResolver.resolve((Object)resourceReference, EntityType.DOCUMENT, new Object[0]);
        if (documentReference == null) {
            throw new IllegalArgumentException(String.valueOf(resourceReference));
        }
        return this.documentAccessBridge.getDocumentURL(new DocumentReference(documentReference), "view", resourceReference.getParameter("queryString"), resourceReference.getParameter("anchor"));
    }

    public String getDocumentEditURL(ResourceReference resourceReference) {
        EntityReference documentReference;
        DocumentReference reference;
        String modifiedQueryString = resourceReference.getParameter("queryString");
        if (StringUtils.isBlank((CharSequence)modifiedQueryString) && (reference = this.documentAccessBridge.getCurrentDocumentReference()) != null) {
            try {
                modifiedQueryString = "parent=" + URLEncoder.encode((String)this.compactEntityReferenceSerializer.serialize((EntityReference)reference, new Object[0]), UTF8.name());
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Failed to URL encode [" + reference + "] using UTF-8.", e);
            }
        }
        if ((documentReference = this.resourceReferenceEntityReferenceResolver.resolve((Object)resourceReference, EntityType.DOCUMENT, new Object[0])) == null) {
            throw new IllegalArgumentException(String.valueOf(resourceReference));
        }
        return this.documentAccessBridge.getDocumentURL(new DocumentReference(documentReference), "create", modifiedQueryString, resourceReference.getParameter("anchor"));
    }

    private String getImageDimension(String dimension, Map<String, String> imageParameters) {
        String value = null;
        String style = imageParameters.get("style");
        if (StringUtils.isNotBlank((CharSequence)style)) {
            try {
                CSSStyleDeclaration sd = this.cssParser.parseStyleDeclaration(new InputSource((Reader)new StringReader(style)));
                value = sd.getPropertyValue(dimension);
            }
            catch (Exception e) {
                this.logger.warn("Failed to parse CSS style [{}]", (Object)style);
            }
        }
        if (StringUtils.isBlank(value)) {
            value = imageParameters.get(dimension);
        }
        return value;
    }

    private Map<String, Object> getImageURLParameters(Map<String, String> imageParameters) {
        String width = StringUtils.removeEnd((String)this.getImageDimension(WIDTH, imageParameters), (String)PIXELS);
        String height = StringUtils.removeEnd((String)this.getImageDimension(HEIGHT, imageParameters), (String)PIXELS);
        boolean useHeight = StringUtils.isNotEmpty((CharSequence)height) && StringUtils.isNumeric((CharSequence)height);
        LinkedHashMap<String, Object> queryString = new LinkedHashMap<String, Object>();
        if (StringUtils.isEmpty((CharSequence)width) || !StringUtils.isNumeric((CharSequence)width)) {
            if (useHeight) {
                queryString.put(HEIGHT, height);
            } else {
                int heightLimit;
                int widthLimit = this.xwikiRenderingConfiguration.getImageWidthLimit();
                if (widthLimit > 0) {
                    queryString.put(WIDTH, widthLimit);
                }
                if ((heightLimit = this.xwikiRenderingConfiguration.getImageHeightLimit()) > 0) {
                    queryString.put(HEIGHT, heightLimit);
                }
                if (widthLimit > 0 && heightLimit > 0) {
                    queryString.put("keepAspectRatio", true);
                }
            }
        } else {
            queryString.put(WIDTH, width);
            if (useHeight) {
                queryString.put(HEIGHT, height);
            }
        }
        return queryString;
    }

    private String extendQueryString(String queryString, Map<String, Object> parameters) {
        ArrayList<BasicNameValuePair> pairs = new ArrayList<BasicNameValuePair>(URLEncodedUtils.parse((String)queryString, (Charset)UTF8, (char[])new char[]{'&'}));
        for (NameValuePair nameValuePair : pairs) {
            parameters.remove(nameValuePair.getName());
        }
        for (Map.Entry entry : parameters.entrySet()) {
            pairs.add(new BasicNameValuePair((String)entry.getKey(), String.valueOf(entry.getValue())));
        }
        return URLEncodedUtils.format(pairs, (Charset)UTF8);
    }
}

