/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.resolver;

import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceProvider;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.model.reference.SpaceReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.listener.reference.ResourceType;

public abstract class AbstractResourceReferenceEntityReferenceResolver
implements EntityReferenceResolver<ResourceReference> {
    @Inject
    @Named(value="current")
    protected EntityReferenceResolver<String> currentEntityReferenceResolver;
    @Inject
    protected EntityReferenceResolver<EntityReference> defaultEntityReferenceResolver;
    @Inject
    @Named(value="current")
    protected Provider<DocumentReference> currentDocumentProvider;
    @Inject
    protected EntityReferenceProvider defaultReferenceProvider;
    @Inject
    protected DocumentAccessBridge documentAccessBridge;
    protected ResourceType resourceType;

    public AbstractResourceReferenceEntityReferenceResolver() {
    }

    public AbstractResourceReferenceEntityReferenceResolver(ResourceType type) {
        this.resourceType = type;
    }

    public EntityReference resolve(ResourceReference resourceReference, EntityType entityType, Object ... parameters) {
        if (resourceReference == null) {
            return null;
        }
        if (this.resourceType != null && !resourceReference.getType().equals((Object)this.resourceType)) {
            throw new IllegalArgumentException(String.format("You must pass a resource reference of type [%s]. [%s] was passed", this.resourceType, resourceReference));
        }
        EntityReference baseReference = this.getBaseReference(resourceReference, parameters);
        EntityReference entityReference = resourceReference.isTyped() ? this.resolveTyped(resourceReference, baseReference) : this.resolveUntyped(resourceReference, baseReference);
        return this.convertReference(entityReference, entityType);
    }

    protected EntityReference resolveUntyped(ResourceReference resourceReference, EntityReference baseReference) {
        return this.resolveTyped(resourceReference, baseReference);
    }

    protected abstract EntityReference resolveTyped(ResourceReference var1, EntityReference var2);

    protected EntityReference getBaseReference(ResourceReference resourceReference, Object ... parameters) {
        EntityReference baseReference;
        EntityReference entityReference = baseReference = parameters.length > 0 && parameters[0] instanceof EntityReference ? (EntityReference)parameters[0] : null;
        if (!resourceReference.getBaseReferences().isEmpty()) {
            baseReference = this.resolveBaseReference(resourceReference.getBaseReferences(), baseReference);
        }
        if (baseReference == null) {
            baseReference = (EntityReference)this.currentDocumentProvider.get();
        }
        return baseReference;
    }

    protected EntityReference resolveBaseReference(List<String> baseReferences, EntityReference defaultBaseReference) {
        EntityReference resolvedBaseReference = defaultBaseReference;
        for (String baseReference : baseReferences) {
            resolvedBaseReference = this.currentEntityReferenceResolver.resolve((Object)baseReference, EntityType.DOCUMENT, new Object[]{resolvedBaseReference});
        }
        return resolvedBaseReference;
    }

    protected EntityReference convertReference(EntityReference entityReference, EntityType entityType) {
        if (entityReference != null && entityType != null && entityReference.getType() != entityType) {
            return this.defaultEntityReferenceResolver.resolve((Object)entityReference, entityType, new Object[0]);
        }
        return entityReference;
    }

    protected DocumentReference resolveDocumentReference(DocumentReference reference, EntityReference baseReference) {
        DocumentReference finalReference = reference;
        String defaultDocumentName = this.defaultReferenceProvider.getDefaultReference(EntityType.DOCUMENT).getName();
        if (!reference.getName().equals(defaultDocumentName) && !Objects.equals(reference, baseReference)) {
            finalReference = this.resolveDocumentReference(finalReference, baseReference, true, defaultDocumentName);
        }
        return finalReference;
    }

    protected DocumentReference resolveDocumentReference(DocumentReference reference, EntityReference baseReference, boolean trySpaceSibling, String defaultDocumentName) {
        DocumentReference finalReference = reference;
        if (!this.documentAccessBridge.exists(reference)) {
            SpaceReference spaceReference = new SpaceReference(reference.getName(), (SpaceReference)reference.getParent());
            finalReference = new DocumentReference(defaultDocumentName, spaceReference);
            if (trySpaceSibling && baseReference != null && baseReference.getName().equals(defaultDocumentName) && !this.documentAccessBridge.exists(finalReference)) {
                EntityReference parentReference = reference.getParent().getParent();
                if (parentReference instanceof SpaceReference) {
                    finalReference = new DocumentReference(reference.getName(), (SpaceReference)parentReference);
                    finalReference = this.resolveDocumentReference(finalReference, baseReference, false, defaultDocumentName);
                } else {
                    spaceReference = new SpaceReference(reference.getName(), (WikiReference)parentReference);
                    finalReference = new DocumentReference(defaultDocumentName, spaceReference);
                }
            }
        }
        return finalReference;
    }
}

