/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.resolver;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.AttachmentReference;
import org.xwiki.model.reference.AttachmentReferenceResolver;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.rendering.internal.resolver.AbstractResourceReferenceEntityReferenceResolver;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.listener.reference.ResourceType;

@Component
@Named(value="attach")
@Singleton
public class AttachmentResourceReferenceEntityReferenceResolver
extends AbstractResourceReferenceEntityReferenceResolver {
    @Inject
    @Named(value="current")
    private AttachmentReferenceResolver<String> currentAttachmentReferenceResolver;

    public AttachmentResourceReferenceEntityReferenceResolver() {
        super(ResourceType.ATTACHMENT);
    }

    @Override
    protected EntityReference resolveTyped(ResourceReference resourceReference, EntityReference baseReference) {
        AttachmentReference attachmentReference = this.currentAttachmentReferenceResolver.resolve((Object)resourceReference.getReference(), new Object[]{baseReference});
        DocumentReference documentReference = attachmentReference.getDocumentReference();
        DocumentReference finalDocumentReference = this.resolveDocumentReference(documentReference, baseReference);
        if (finalDocumentReference != documentReference) {
            attachmentReference = new AttachmentReference(attachmentReference.getName(), finalDocumentReference);
        }
        return attachmentReference;
    }
}

