/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.wiki;

import com.steadystate.css.parser.CSSOMParser;
import com.steadystate.css.parser.SACParserCSS21;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.Parser;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.bridge.SkinAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.AttachmentReference;
import org.xwiki.model.reference.AttachmentReferenceResolver;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.SpaceReferenceResolver;
import org.xwiki.rendering.internal.configuration.XWikiRenderingConfiguration;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.listener.reference.ResourceType;
import org.xwiki.rendering.wiki.WikiModel;

@Component
@Singleton
public class XWikiWikiModel
implements WikiModel {
    private static final String PIXELS = "px";
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    @Inject
    private XWikiRenderingConfiguration xwikiRenderingConfiguration;
    @Inject
    private DocumentAccessBridge documentAccessBridge;
    @Inject
    private SkinAccessBridge skinAccessBridge;
    @Inject
    @Named(value="compactwiki")
    private EntityReferenceSerializer<String> compactEntityReferenceSerializer;
    @Inject
    @Named(value="current")
    private AttachmentReferenceResolver<String> currentAttachmentReferenceResolver;
    @Inject
    @Named(value="current")
    private DocumentReferenceResolver<String> currentDocumentReferenceResolver;
    @Inject
    @Named(value="current")
    private SpaceReferenceResolver<String> currentSpaceReferenceResolver;
    @Inject
    private EntityReferenceResolver<ResourceReference> resourceReferenceEntityReferenceResolver;
    @Inject
    private Logger logger;
    private final CSSOMParser cssParser = new CSSOMParser((Parser)new SACParserCSS21());

    public String getLinkURL(ResourceReference linkReference) {
        EntityReference attachmentReference = this.resourceReferenceEntityReferenceResolver.resolve((Object)linkReference, EntityType.ATTACHMENT, new Object[0]);
        if (attachmentReference == null) {
            throw new IllegalArgumentException(String.valueOf(attachmentReference));
        }
        return this.documentAccessBridge.getAttachmentURL(new AttachmentReference(attachmentReference), linkReference.getParameter("queryString"), false);
    }

    public String getImageURL(ResourceReference imageReference, Map<String, String> parameters) {
        String extraQueryString;
        if (imageReference.getType().equals((Object)ResourceType.ICON)) {
            return this.skinAccessBridge.getIconURL(imageReference.getReference());
        }
        if (this.xwikiRenderingConfiguration.isImageDimensionsIncludedInImageURL() && !(extraQueryString = StringUtils.removeStart((String)this.getImageURLQueryString(parameters), (String)"&")).isEmpty()) {
            String queryString = imageReference.getParameter("queryString");
            queryString = StringUtils.isEmpty((CharSequence)queryString) ? extraQueryString : queryString + '&' + extraQueryString;
            ResourceReference scaledImageReference = imageReference.clone();
            scaledImageReference.setParameter("queryString", queryString);
            return this.getLinkURL(scaledImageReference);
        }
        return this.getLinkURL(imageReference);
    }

    public boolean isDocumentAvailable(ResourceReference resourceReference) {
        EntityReference documentReference = this.resourceReferenceEntityReferenceResolver.resolve((Object)resourceReference, EntityType.DOCUMENT, new Object[0]);
        if (documentReference == null) {
            throw new IllegalArgumentException(String.valueOf(resourceReference));
        }
        return this.documentAccessBridge.exists(new DocumentReference(documentReference));
    }

    public String getDocumentViewURL(ResourceReference resourceReference) {
        EntityReference documentReference = this.resourceReferenceEntityReferenceResolver.resolve((Object)resourceReference, EntityType.DOCUMENT, new Object[0]);
        if (documentReference == null) {
            throw new IllegalArgumentException(String.valueOf(resourceReference));
        }
        return this.documentAccessBridge.getDocumentURL(new DocumentReference(documentReference), "view", resourceReference.getParameter("queryString"), resourceReference.getParameter("anchor"));
    }

    public String getDocumentEditURL(ResourceReference resourceReference) {
        EntityReference documentReference;
        DocumentReference reference;
        String modifiedQueryString = resourceReference.getParameter("queryString");
        if (StringUtils.isBlank((CharSequence)modifiedQueryString) && (reference = this.documentAccessBridge.getCurrentDocumentReference()) != null) {
            try {
                modifiedQueryString = "parent=" + URLEncoder.encode((String)this.compactEntityReferenceSerializer.serialize((EntityReference)reference, new Object[0]), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Failed to URL encode [" + (String)this.compactEntityReferenceSerializer.serialize((EntityReference)reference, new Object[0]) + "] using UTF-8.", e);
            }
        }
        if ((documentReference = this.resourceReferenceEntityReferenceResolver.resolve((Object)resourceReference, EntityType.DOCUMENT, new Object[0])) == null) {
            throw new IllegalArgumentException(String.valueOf(resourceReference));
        }
        return this.documentAccessBridge.getDocumentURL(new DocumentReference(documentReference), "create", modifiedQueryString, resourceReference.getParameter("anchor"));
    }

    private String getImageDimension(String dimension, Map<String, String> imageParameters) {
        String value = null;
        String style = imageParameters.get("style");
        if (StringUtils.isNotBlank((CharSequence)style)) {
            try {
                CSSStyleDeclaration sd = this.cssParser.parseStyleDeclaration(new InputSource((Reader)new StringReader(style)));
                value = sd.getPropertyValue(dimension);
            }
            catch (Exception e) {
                this.logger.warn("Failed to parse CSS style [{}]", (Object)style);
            }
        }
        if (StringUtils.isBlank(value)) {
            value = imageParameters.get(dimension);
        }
        return value;
    }

    private String getImageURLQueryString(Map<String, String> imageParameters) {
        String width = StringUtils.removeEnd((String)this.getImageDimension(WIDTH, imageParameters), (String)PIXELS);
        String height = StringUtils.removeEnd((String)this.getImageDimension(HEIGHT, imageParameters), (String)PIXELS);
        boolean useHeight = StringUtils.isNotEmpty((CharSequence)height) && StringUtils.isNumeric((CharSequence)height);
        StringBuilder queryString = new StringBuilder();
        if (StringUtils.isEmpty((CharSequence)width) || !StringUtils.isNumeric((CharSequence)width)) {
            if (useHeight) {
                queryString.append('&').append(HEIGHT).append('=').append(height);
            } else {
                int heightLimit;
                int widthLimit = this.xwikiRenderingConfiguration.getImageWidthLimit();
                if (widthLimit > 0) {
                    queryString.append('&').append(WIDTH).append('=').append(widthLimit);
                }
                if ((heightLimit = this.xwikiRenderingConfiguration.getImageHeightLimit()) > 0) {
                    queryString.append('&').append(HEIGHT).append('=').append(heightLimit);
                }
                if (widthLimit > 0 && heightLimit > 0) {
                    queryString.append("&keepAspectRatio=").append(true);
                }
            }
        } else {
            queryString.append('&').append(WIDTH).append('=').append(width);
            if (useHeight) {
                queryString.append('&').append(HEIGHT).append('=').append(height);
            }
        }
        return queryString.toString();
    }
}

