/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.resource;

import org.xwiki.component.annotation.Role;
import org.xwiki.stability.Unstable;

/**
 * The Resource Handler Manager's goal is to locate the right {@link ResourceReferenceHandler}
 * implementations to call in the right order.
 *
 * @version $Id: b974dc67a7e7f1bb54d4220de9fb0c4bad655203 $
 * @since 6.1M2
 */
@Role
@Unstable
public interface ResourceReferenceHandlerManager
{
    /**
     * Handles a passed {@link org.xwiki.resource.ResourceReference}.
     *
     * @param reference the Resource Reference to handle
     * @throws ResourceReferenceHandlerException if an error happens during the Handler execution, for example if no
     *         Handler was found to handle the passed Resource Reference
     */
    void handle(ResourceReference reference) throws ResourceReferenceHandlerException;
}
