/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.resource.internal;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.resource.NotFoundResourceHandlerException;
import org.xwiki.resource.ResourceReference;
import org.xwiki.resource.ResourceReferenceHandler;
import org.xwiki.resource.ResourceReferenceHandlerException;
import org.xwiki.resource.ResourceReferenceHandlerManager;
import org.xwiki.resource.internal.DefaultResourceReferenceHandlerChain;

public abstract class AbstractResourceReferenceHandlerManager<T>
implements ResourceReferenceHandlerManager<T> {
    @Inject
    @Named(value="context")
    private ComponentManager contextComponentManager;
    @Inject
    private Logger logger;

    protected abstract boolean matches(ResourceReferenceHandler var1, T var2);

    protected abstract T extractResourceReferenceQualifier(ResourceReference var1);

    public void handle(ResourceReference reference) throws ResourceReferenceHandlerException {
        Set<ResourceReferenceHandler> orderedHandlers = this.getMatchingHandlers(this.extractResourceReferenceQualifier(reference));
        if (orderedHandlers.isEmpty()) {
            throw new NotFoundResourceHandlerException(reference);
        }
        DefaultResourceReferenceHandlerChain chain = new DefaultResourceReferenceHandlerChain(orderedHandlers);
        chain.handleNext(reference);
    }

    public boolean canHandle(T resourceReferenceQualifier) {
        boolean result;
        try {
            result = !this.getMatchingHandlers(resourceReferenceQualifier).isEmpty();
        }
        catch (ResourceReferenceHandlerException e) {
            this.logger.warn("Failed to list Resource Reference Handers. Error [{}]", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            result = false;
        }
        return result;
    }

    private Set<ResourceReferenceHandler> getMatchingHandlers(T resourceReferenceQualifier) throws ResourceReferenceHandlerException {
        TreeSet<ResourceReferenceHandler> orderedHandlers = new TreeSet<ResourceReferenceHandler>();
        for (ResourceReferenceHandler handler : this.getHandlers(resourceReferenceQualifier.getClass())) {
            if (!this.matches(handler, resourceReferenceQualifier)) continue;
            orderedHandlers.add(handler);
        }
        return orderedHandlers;
    }

    private List<ResourceReferenceHandler> getHandlers(Class typeClass) throws ResourceReferenceHandlerException {
        try {
            return this.contextComponentManager.getInstanceList((Type)new DefaultParameterizedType(null, ResourceReferenceHandler.class, new Type[]{typeClass}));
        }
        catch (ComponentLookupException e) {
            throw new ResourceReferenceHandlerException("Failed to locate Resource Reference Handler components", (Throwable)e);
        }
    }
}

