/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.resource.entity;

import java.util.Locale;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.resource.AbstractResourceReference;
import org.xwiki.resource.ResourceType;
import org.xwiki.resource.entity.EntityResourceAction;
import org.xwiki.stability.Unstable;
import org.xwiki.text.XWikiToStringBuilder;

@Unstable
public class EntityResourceReference
extends AbstractResourceReference {
    public static final ResourceType TYPE = new ResourceType("entity");
    private static final String REVISION_PARAMETER_NAME = "rev";
    private EntityReference entityReference;
    private Locale locale;
    private EntityResourceAction action;

    public EntityResourceReference(EntityReference entityReference, EntityResourceAction action) {
        this.setType(TYPE);
        this.setEntityReference(entityReference);
        this.setAction(action);
    }

    public EntityResourceAction getAction() {
        return this.action;
    }

    public void setAction(EntityResourceAction action) {
        this.action = action;
    }

    public EntityReference getEntityReference() {
        return this.entityReference;
    }

    public void setEntityReference(EntityReference entityReference) {
        this.entityReference = entityReference;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setRevision(String revision) {
        this.addParameter(REVISION_PARAMETER_NAME, revision);
    }

    public String getRevision() {
        return this.getParameterValue(REVISION_PARAMETER_NAME);
    }

    public int hashCode() {
        return new HashCodeBuilder(9, 9).appendSuper(super.hashCode()).append((Object)this.getEntityReference()).append((Object)this.getLocale()).append((Object)this.getAction()).toHashCode();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        EntityResourceReference rhs = (EntityResourceReference)((Object)object);
        return new EqualsBuilder().appendSuper(super.equals(object)).append((Object)this.getEntityReference(), (Object)rhs.getEntityReference()).append((Object)this.getLocale(), (Object)rhs.getLocale()).append((Object)this.getAction(), (Object)rhs.getAction()).isEquals();
    }

    public String toString() {
        XWikiToStringBuilder builder = new XWikiToStringBuilder((Object)this);
        builder.appendSuper(super.toString());
        builder.append("reference", (Object)this.getEntityReference());
        builder.append("action", (Object)this.getAction());
        builder.append("locale", (Object)this.getLocale());
        return builder.toString();
    }
}

