/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.resource.servlet;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import javax.inject.Inject;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.tika.Tika;
import org.slf4j.Logger;
import org.xwiki.container.Container;
import org.xwiki.container.Request;
import org.xwiki.container.Response;
import org.xwiki.container.servlet.ServletRequest;
import org.xwiki.container.servlet.ServletResponse;
import org.xwiki.resource.AbstractResourceReferenceHandler;
import org.xwiki.resource.ResourceReference;
import org.xwiki.resource.ResourceReferenceHandlerChain;
import org.xwiki.resource.ResourceReferenceHandlerException;
import org.xwiki.resource.ResourceType;
import org.xwiki.stability.Unstable;

@Unstable
public abstract class AbstractServletResourceReferenceHandler<R extends ResourceReference>
extends AbstractResourceReferenceHandler<ResourceType> {
    private static final long CACHE_DURATION = 31536000000L;
    @Inject
    private Logger logger;
    @Inject
    private Container container;
    private Tika tika = new Tika();

    public void handle(ResourceReference resourceReference, ResourceReferenceHandlerChain chain) throws ResourceReferenceHandlerException {
        ResourceReference typedResourceReference = resourceReference;
        if (!this.isResourceAccessible(typedResourceReference)) {
            this.sendError(403, "You are not allowed to view [%s].", this.getResourceName(typedResourceReference));
        } else if (!this.shouldBrowserUseCachedContent(typedResourceReference)) {
            InputStream resourceStream = this.getResourceStream(typedResourceReference);
            if (resourceStream != null) {
                try {
                    this.serveResource(typedResourceReference, this.filterResource(typedResourceReference, resourceStream));
                }
                catch (ResourceReferenceHandlerException e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                    this.sendError(500, e.getMessage(), new Object[0]);
                }
            } else {
                this.sendError(404, "Resource not found [%s].", this.getResourceName(typedResourceReference));
            }
        }
        chain.handleNext(resourceReference);
    }

    protected boolean isResourceAccessible(R resourceReference) {
        return true;
    }

    private boolean shouldBrowserUseCachedContent(R resourceReference) {
        Response response;
        Request request = this.container.getRequest();
        if (request instanceof ServletRequest && ((ServletRequest)request).getHttpServletRequest().getHeader("If-Modified-Since") != null && this.isResourceCacheable(resourceReference) && (response = this.container.getResponse()) instanceof ServletResponse) {
            ((ServletResponse)response).getHttpServletResponse().setStatus(304);
            return true;
        }
        return false;
    }

    protected boolean isResourceCacheable(R resourceReference) {
        return true;
    }

    protected abstract InputStream getResourceStream(R var1);

    protected abstract String getResourceName(R var1);

    private void serveResource(R resourceReference, InputStream rawResourceStream) throws ResourceReferenceHandlerException {
        InputStream resourceStream = rawResourceStream;
        String resourceName = this.getResourceName(resourceReference);
        if (!resourceStream.markSupported()) {
            resourceStream = new BufferedInputStream(resourceStream);
        }
        try {
            Response response = this.container.getResponse();
            this.setResponseHeaders(response, resourceReference);
            response.setContentType(this.tika.detect(resourceStream, resourceName));
            IOUtils.copy((InputStream)resourceStream, (OutputStream)response.getOutputStream());
        }
        catch (Exception e) {
            throw new ResourceReferenceHandlerException(String.format("Failed to read resource [%s]", resourceName), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)resourceStream);
        }
    }

    protected InputStream filterResource(R resourceReference, InputStream resourceStream) throws ResourceReferenceHandlerException {
        return resourceStream;
    }

    private void setResponseHeaders(Response response, R resourceReference) {
        if (response instanceof ServletResponse && this.isResourceCacheable(resourceReference)) {
            HttpServletResponse httpResponse = ((ServletResponse)response).getHttpServletResponse();
            httpResponse.setHeader("Cache-Control", "public");
            httpResponse.setDateHeader("Expires", new Date().getTime() + 31536000000L);
            httpResponse.setDateHeader("Last-Modified", new Date().getTime());
        }
    }

    private void sendError(int statusCode, String message, Object ... parameters) throws ResourceReferenceHandlerException {
        Response response = this.container.getResponse();
        if (response instanceof ServletResponse) {
            HttpServletResponse httpResponse = ((ServletResponse)response).getHttpServletResponse();
            try {
                httpResponse.sendError(statusCode, String.format(message, parameters));
            }
            catch (IOException e) {
                throw new ResourceReferenceHandlerException(String.format("Failed to return status code [%s].", statusCode), (Throwable)e);
            }
        }
    }
}

