/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.rest.internal.representations;

import java.io.IOException;
import java.io.InputStream;

import javax.ws.rs.ext.MessageBodyReader;

import org.apache.commons.io.IOUtils;
import org.xwiki.rest.XWikiRestComponent;

/**
 * @version $Id: 38129a281f53624e0fd8047b254d4460addda187 $
 * @param <T> the type of data returned by the read method
 */
public abstract class AbstractTextPlainReader<T> implements MessageBodyReader<T>, XWikiRestComponent
{
    protected String getEntityAsString(InputStream entityStream) throws IOException
    {
        if (entityStream == null) {
            return "";
        }
        return IOUtils.toString(entityStream);
    }
}
