/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.event.ComponentDescriptorAddedEvent;
import org.xwiki.component.event.ComponentDescriptorEvent;
import org.xwiki.component.event.ComponentDescriptorRemovedEvent;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.job.event.JobFinishedEvent;
import org.xwiki.job.event.JobStartedEvent;
import org.xwiki.observation.AbstractEventListener;
import org.xwiki.observation.ObservationContext;
import org.xwiki.observation.event.BeginEvent;
import org.xwiki.observation.event.Event;
import org.xwiki.rest.XWikiRestComponent;
import org.xwiki.rest.internal.JaxRsServletProvider;

@Component
@Named(value="org.xwiki.rest.internal.JaxRsServletReloader")
@Singleton
public class JaxRsServletReloader
extends AbstractEventListener {
    public static final String HINT = "org.xwiki.rest.internal.JaxRsServletReloader";
    private static final String RESTART = "rest.restart";
    private static final JobStartedEvent PARENT = new JobStartedEvent();
    @Inject
    private Logger logger;
    @Inject
    private ObservationContext observationContext;
    @Inject
    private Execution execution;
    @Inject
    private JaxRsServletProvider servletProvider;

    public JaxRsServletReloader() {
        super(HINT, new Event[]{new ComponentDescriptorAddedEvent(XWikiRestComponent.class), new ComponentDescriptorRemovedEvent(XWikiRestComponent.class), new JobFinishedEvent("install"), new JobFinishedEvent("uninstall")});
    }

    public void onEvent(Event event, Object source, Object data) {
        if (this.servletProvider.get() != null) {
            if (event instanceof ComponentDescriptorEvent) {
                this.onComponentDescriptorEvent();
            } else {
                this.flush();
            }
        }
    }

    private void onComponentDescriptorEvent() {
        if (this.observationContext.isIn((BeginEvent)PARENT)) {
            this.restartLater();
        } else {
            this.restartNow();
        }
    }

    private void restartLater() {
        ExecutionContext context = this.execution.getContext();
        if (context != null) {
            context.setProperty(RESTART, (Object)true);
        }
    }

    private void restartNow() {
        try {
            this.servletProvider.reload();
            ExecutionContext context = this.execution.getContext();
            if (context != null) {
                context.removeProperty(RESTART);
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to restart the JAX-RS application", (Throwable)e);
        }
    }

    private void flush() {
        ExecutionContext context = this.execution.getContext();
        if (context != null && context.hasProperty(RESTART)) {
            this.restartNow();
        }
    }
}

