/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal.resources.attachments;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Attachment;
import com.xpn.xwiki.api.Document;
import java.net.URL;
import java.util.ArrayList;
import javax.inject.Named;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.suigeneris.jrcs.rcs.Version;
import org.xwiki.component.annotation.Component;
import org.xwiki.rest.XWikiResource;
import org.xwiki.rest.XWikiRestException;
import org.xwiki.rest.internal.DomainObjectFactory;
import org.xwiki.rest.internal.RangeIterable;
import org.xwiki.rest.internal.Utils;
import org.xwiki.rest.model.jaxb.Attachments;
import org.xwiki.rest.resources.attachments.AttachmentHistoryResource;

@Component
@Named(value="org.xwiki.rest.internal.resources.attachments.AttachmentHistoryResourceImpl")
public class AttachmentHistoryResourceImpl
extends XWikiResource
implements AttachmentHistoryResource {
    public Attachments getAttachmentHistory(String wikiName, String spaceName, String pageName, String attachmentName, Integer start, Integer number) throws XWikiRestException {
        try {
            XWikiResource.DocumentInfo documentInfo = this.getDocumentInfo(wikiName, spaceName, pageName, null, null, true, false);
            Document doc = documentInfo.getDocument();
            Attachment xwikiAttachment = doc.getAttachment(attachmentName);
            if (xwikiAttachment == null) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            Attachments attachments = new Attachments();
            Version[] versions = xwikiAttachment.getVersions();
            ArrayList<Version> versionList = new ArrayList<Version>();
            for (Version version : versions) {
                versionList.add(version);
            }
            RangeIterable ri = new RangeIterable(versionList, start, number);
            for (Version version : ri) {
                Attachment xwikiAttachmentAtVersion = xwikiAttachment.getAttachmentRevision(version.toString());
                URL url = Utils.getXWikiContext(this.componentManager).getURLFactory().createAttachmentRevisionURL(attachmentName, spaceName, doc.getDocumentReference().getName(), version.toString(), null, wikiName, Utils.getXWikiContext(this.componentManager));
                String attachmentXWikiAbsoluteUrl = url.toString();
                String attachmentXWikiRelativeUrl = Utils.getXWikiContext(this.componentManager).getURLFactory().getURL(url, Utils.getXWikiContext(this.componentManager));
                attachments.getAttachments().add(DomainObjectFactory.createAttachmentAtVersion(this.objectFactory, this.uriInfo.getBaseUri(), xwikiAttachmentAtVersion, attachmentXWikiRelativeUrl, attachmentXWikiAbsoluteUrl, Utils.getXWikiApi(this.componentManager), false));
            }
            return attachments;
        }
        catch (XWikiException e) {
            throw new XWikiRestException((Throwable)e);
        }
    }
}

