/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal.resources.classes;

import com.xpn.xwiki.objects.classes.ListClass;
import java.util.Iterator;
import javax.inject.Inject;
import org.xwiki.query.Query;
import org.xwiki.query.QueryBuilder;
import org.xwiki.rest.internal.resources.classes.AbstractDocumentListClassPropertyValuesProvider;
import org.xwiki.rest.model.jaxb.PropertyValues;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;

public abstract class AbstractUsersAndGroupsClassPropertyValuesProvider<T extends ListClass>
extends AbstractDocumentListClassPropertyValuesProvider<T> {
    @Inject
    protected WikiDescriptorManager wikiDescriptorManager;

    protected abstract QueryBuilder<T> getAllowedValuesQueryBuilder();

    protected PropertyValues getLocalAllowedValues(T propertyDefinition, int limit, String filter) throws Exception {
        return this.getValues(this.getAllowedValuesQueryBuilder().build(propertyDefinition), limit, filter, propertyDefinition);
    }

    protected PropertyValues getGlobalAllowedValues(T propertyDefinition, int limit, String filter) throws Exception {
        Query query = this.getAllowedValuesQueryBuilder().build(propertyDefinition);
        query.setWiki(this.wikiDescriptorManager.getMainWikiId());
        return this.getValues(query, limit, filter, propertyDefinition);
    }

    protected PropertyValues getLocalAndGlobalAllowedValues(T propertyDefinition, int limit, String filter) throws Exception {
        int oldSize;
        PropertyValues localUsers = this.getLocalAllowedValues(propertyDefinition, limit, filter);
        PropertyValues globalUsers = this.getGlobalAllowedValues(propertyDefinition, limit, filter);
        Iterator localUsersIterator = localUsers.getPropertyValues().iterator();
        Iterator globalUsersIterator = globalUsers.getPropertyValues().iterator();
        PropertyValues users = new PropertyValues();
        do {
            oldSize = users.getPropertyValues().size();
            if (localUsersIterator.hasNext() && (limit <= 0 || users.getPropertyValues().size() < limit)) {
                users.getPropertyValues().add(localUsersIterator.next());
            }
            if (!globalUsersIterator.hasNext() || limit > 0 && users.getPropertyValues().size() >= limit) continue;
            users.getPropertyValues().add(globalUsersIterator.next());
        } while (oldSize < users.getPropertyValues().size());
        users.getPropertyValues().sort((alice, bob) -> {
            String aliceName = alice.getMetaData().getOrDefault("label", alice.getValue()).toString();
            String bobName = bob.getMetaData().getOrDefault("label", alice.getValue()).toString();
            return aliceName.compareToIgnoreCase(bobName);
        });
        return users;
    }
}

