/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal.resources.classes;

import com.xpn.xwiki.XWikiException;
import java.net.URI;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.ClassPropertyReference;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.rest.XWikiResource;
import org.xwiki.rest.XWikiRestException;
import org.xwiki.rest.internal.Utils;
import org.xwiki.rest.model.jaxb.Link;
import org.xwiki.rest.model.jaxb.PropertyValue;
import org.xwiki.rest.model.jaxb.PropertyValues;
import org.xwiki.rest.resources.classes.ClassPropertyResource;
import org.xwiki.rest.resources.classes.ClassPropertyValuesProvider;
import org.xwiki.rest.resources.classes.ClassPropertyValuesResource;
import org.xwiki.security.authorization.AccessDeniedException;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;

@Component
@Named(value="org.xwiki.rest.internal.resources.classes.ClassPropertyValuesResourceImpl")
public class ClassPropertyValuesResourceImpl
extends XWikiResource
implements ClassPropertyValuesResource {
    @Inject
    @Named(value="currentmixed")
    private DocumentReferenceResolver<String> resolver;
    @Inject
    private ContextualAuthorizationManager authorization;
    @Inject
    private ClassPropertyValuesProvider propertyValuesProvider;

    public PropertyValues getClassPropertyValues(String wikiName, String className, String propertyName, Integer limit, List<String> filterParameters, Boolean isExactMatch) throws XWikiRestException {
        DocumentReference classReference = this.resolver.resolve((Object)className, new Object[]{new WikiReference(wikiName)});
        ClassPropertyReference classPropertyReference = new ClassPropertyReference(propertyName, classReference);
        try {
            this.authorization.checkAccess(Right.VIEW, (EntityReference)classPropertyReference);
        }
        catch (AccessDeniedException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.UNAUTHORIZED);
        }
        if (!this.exists(classPropertyReference)) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        URI propertyURI = Utils.createURI(this.uriInfo.getBaseUri(), ClassPropertyResource.class, wikiName, className, propertyName);
        Link propertyLink = this.objectFactory.createLink();
        propertyLink.setHref(propertyURI.toString());
        propertyLink.setRel("http://www.xwiki.org/rel/property");
        PropertyValues propertyValues = new PropertyValues();
        if (isExactMatch.booleanValue()) {
            for (String filterParameter : filterParameters) {
                PropertyValue value = this.propertyValuesProvider.getValue(classPropertyReference, (Object)filterParameter);
                if (value == null) continue;
                propertyValues.getPropertyValues().add(value);
            }
        } else {
            propertyValues = this.propertyValuesProvider.getValues(classPropertyReference, limit.intValue(), filterParameters.toArray());
        }
        propertyValues.getLinks().add(propertyLink);
        return propertyValues;
    }

    private boolean exists(ClassPropertyReference classPropertyReference) throws XWikiRestException {
        try {
            return this.getXWikiContext().getWiki().getDocument((EntityReference)classPropertyReference, this.getXWikiContext()).getXClass().get(classPropertyReference.getName()) != null;
        }
        catch (XWikiException e) {
            throw new XWikiRestException((Throwable)e);
        }
    }
}

