/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal.resources.classes;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Class;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.rest.XWikiResource;
import org.xwiki.rest.XWikiRestException;
import org.xwiki.rest.internal.ModelFactory;
import org.xwiki.rest.internal.Utils;
import org.xwiki.rest.resources.classes.ClassResource;
import org.xwiki.security.authorization.AccessDeniedException;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;

@Component
@Named(value="org.xwiki.rest.internal.resources.classes.ClassResourceImpl")
public class ClassResourceImpl
extends XWikiResource
implements ClassResource {
    @Inject
    private ModelFactory utils;
    @Inject
    private ContextualAuthorizationManager authorization;
    @Inject
    @Named(value="currentmixed")
    private DocumentReferenceResolver<String> resolver;

    public org.xwiki.rest.model.jaxb.Class getClass(String wikiName, String className) throws XWikiRestException {
        String database = Utils.getXWikiContext(this.componentManager).getWikiId();
        try {
            Utils.getXWikiContext(this.componentManager).setWikiId(wikiName);
            DocumentReference classReference = this.resolver.resolve((Object)className, new Object[]{new WikiReference(wikiName)});
            this.authorization.checkAccess(Right.VIEW, (EntityReference)classReference);
            Class xwikiClass = Utils.getXWikiApi(this.componentManager).getClass((EntityReference)classReference);
            if (xwikiClass == null) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            org.xwiki.rest.model.jaxb.Class clazz = this.utils.toRestClass(this.uriInfo.getBaseUri(), xwikiClass);
            return clazz;
        }
        catch (XWikiException e) {
            throw new XWikiRestException((Throwable)e);
        }
        catch (AccessDeniedException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.UNAUTHORIZED);
        }
        finally {
            Utils.getXWikiContext(this.componentManager).setWikiId(database);
        }
    }
}

