/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal.resources.job;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.job.JobRequestContext;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.job.AbstractRequest;
import org.xwiki.job.DefaultRequest;
import org.xwiki.job.Job;
import org.xwiki.job.JobException;
import org.xwiki.job.Request;
import org.xwiki.rest.XWikiJobResource;
import org.xwiki.rest.XWikiRestException;
import org.xwiki.rest.internal.ModelFactory;
import org.xwiki.rest.model.jaxb.JobRequest;
import org.xwiki.rest.model.jaxb.JobStatus;
import org.xwiki.rest.resources.job.JobsResource;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;

@Component
@Named(value="org.xwiki.rest.internal.resources.job.JobsResourceImpl")
public class JobsResourceImpl
extends XWikiJobResource
implements JobsResource {
    @Inject
    private ModelFactory factory;
    @Inject
    private ContextualAuthorizationManager authorization;

    public JobStatus executeJob(String jobType, boolean async, JobRequest restJobRequest) throws XWikiRestException {
        Job job;
        if (!this.authorization.hasAccess(Right.PROGRAM, null)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        DefaultRequest request = this.factory.toJobRequest(restJobRequest);
        if (request == null) {
            request = new DefaultRequest();
        }
        try {
            if (request.getProperty("oldcore.xwikicontext") == null) {
                JobRequestContext.set((AbstractRequest)request, (XWikiContext)((XWikiContext)this.xcontextProvider.get()));
            }
            job = this.jobExecutor.execute(jobType, (Request)request);
        }
        catch (JobException e) {
            throw new XWikiRestException("Failed to start job", (Throwable)e);
        }
        if (!async) {
            try {
                job.join();
            }
            catch (InterruptedException e) {
                throw new XWikiRestException("The job has been interrupted", (Throwable)e);
            }
            if (job.getStatus().getError() != null) {
                throw new XWikiRestException(String.format("The job failed with error [%s]", ExceptionUtils.getRootCauseMessage((Throwable)job.getStatus().getError())), job.getStatus().getError());
            }
        }
        org.xwiki.job.event.status.JobStatus status = job.getStatus();
        return this.factory.toRestJobStatus(status, null, true, false, false, null);
    }
}

