/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal.resources.objects;

import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.rest.XWikiResource;
import org.xwiki.rest.XWikiRestException;
import org.xwiki.rest.internal.DomainObjectFactory;
import org.xwiki.rest.internal.Utils;
import org.xwiki.rest.model.jaxb.ObjectSummary;
import org.xwiki.rest.model.jaxb.Objects;
import org.xwiki.rest.resources.objects.AllObjectsForClassNameResource;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;

@Component
@Named(value="org.xwiki.rest.internal.resources.objects.AllObjectsForClassNameResourceImpl")
public class AllObjectsForClassNameResourceImpl
extends XWikiResource
implements AllObjectsForClassNameResource {
    @Inject
    private ContextualAuthorizationManager authorization;

    public Objects getObjects(String wikiName, String className, Integer start, Integer number, String order, Boolean withPrettyNames) throws XWikiRestException {
        String database = Utils.getXWikiContext(this.componentManager).getWikiId();
        try {
            Objects objects = new Objects();
            Utils.getXWikiContext(this.componentManager).setWikiId(wikiName);
            String query = "select doc, obj from BaseObject as obj, XWikiDocument as doc where obj.name=doc.fullName and obj.className=:className";
            if ("date".equals(order)) {
                query = query + " order by doc.date desc";
            }
            List queryResult = null;
            queryResult = this.queryManager.createQuery(query, "xwql").bindValue("className", (Object)className).setLimit(number.intValue()).setOffset(start.intValue()).execute();
            for (Object object : queryResult) {
                Object[] fields = (Object[])object;
                XWikiDocument xwikiDocument = (XWikiDocument)fields[0];
                xwikiDocument.setDatabase(wikiName);
                if (!this.authorization.hasAccess(Right.VIEW, (EntityReference)xwikiDocument.getDocumentReference())) continue;
                Document doc = new Document(xwikiDocument, Utils.getXWikiContext(this.componentManager));
                BaseObject xwikiObject = (BaseObject)fields[1];
                ObjectSummary objectSummary = DomainObjectFactory.createObjectSummary(this.objectFactory, this.uriInfo.getBaseUri(), Utils.getXWikiContext(this.componentManager), doc, xwikiObject, false, Utils.getXWikiApi(this.componentManager), withPrettyNames);
                objects.getObjectSummaries().add(objectSummary);
            }
            Objects objects2 = objects;
            return objects2;
        }
        catch (Exception e) {
            throw new XWikiRestException((Throwable)e);
        }
        finally {
            Utils.getXWikiContext(this.componentManager).setWikiId(database);
        }
    }
}

