/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal.resources.search;

import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.rest.internal.resources.search.AbstractDatabaseSearchSource;

@Component
@Named(value="hql")
@Singleton
public class HQLSearchSource
extends AbstractDatabaseSearchSource {
    public HQLSearchSource() {
        super("hql");
    }

    @Override
    protected String resolveQuery(boolean distinct, String query) {
        StringBuilder builder = new StringBuilder();
        builder.append("select ");
        if (distinct) {
            builder.append("distinct ");
        }
        builder.append("doc.fullName, doc.space, doc.name, doc.language from XWikiDocument as doc ");
        if (query.toLowerCase().startsWith("from")) {
            builder.append(',');
            builder.append(query.substring(4));
        } else {
            builder.append(query);
        }
        return builder.toString();
    }
}

