/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal.resources.user;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.classes.PropertyClass;
import com.xpn.xwiki.objects.classes.StaticListClass;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.rest.XWikiResource;
import org.xwiki.rest.XWikiRestException;
import org.xwiki.rest.internal.ModelFactory;
import org.xwiki.rest.model.jaxb.Object;
import org.xwiki.rest.model.jaxb.Property;
import org.xwiki.rest.resources.user.CurrentUserPropertyResource;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;

@Component
@Named(value="org.xwiki.rest.internal.resources.user.CurrentUserPropertyResourceImpl")
public class CurrentUserPropertyResourceImpl
extends XWikiResource
implements CurrentUserPropertyResource {
    private static final EntityReference USER_REFERENCE = new EntityReference("XWikiUsers", EntityType.DOCUMENT, new EntityReference("XWiki", EntityType.SPACE));
    @Inject
    private ContextualAuthorizationManager authorizationManager;
    @Inject
    private Execution execution;
    @Inject
    private ModelFactory factory;

    public Response setNextPropertyValue(String propertyName) throws XWikiRestException {
        XWikiContext xcontext = (XWikiContext)this.execution.getContext().getProperty("xwikicontext");
        try {
            if (xcontext.getUserReference() == null) {
                throw new XWikiRestException(String.format("Cannot change property [%s] since the current user is guest", propertyName));
            }
            XWikiDocument userDocument = xcontext.getWiki().getDocument(xcontext.getUserReference(), xcontext);
            if (!this.authorizationManager.hasAccess(Right.EDIT, (EntityReference)userDocument.getDocumentReference())) {
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            BaseObject object = userDocument.getXObject(USER_REFERENCE);
            if (object == null) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            java.lang.Object newValue = this.computeNewValue(object, propertyName, xcontext);
            if (newValue != null) {
                object.set(propertyName, newValue, xcontext);
                xcontext.getWiki().saveDocument(userDocument, "Setting next value", true, xcontext);
                return this.buildResponse(userDocument, propertyName, xcontext);
            }
            return Response.status((Response.Status)Response.Status.NOT_MODIFIED).build();
        }
        catch (XWikiException e) {
            throw new XWikiRestException(String.format("Failed to change property [%s] for user [%s]", propertyName, xcontext.getUserReference()), (Throwable)e);
        }
    }

    private java.lang.Object computeNewValue(BaseObject object, String propertyName, XWikiContext xcontext) {
        java.lang.Object newValue = null;
        PropertyClass propertyClass = (PropertyClass)object.getXClass(xcontext).get(propertyName);
        if (propertyClass.getClassType().equals("Boolean")) {
            newValue = object.getIntValue(propertyName) == 1 ? Integer.valueOf(0) : Integer.valueOf(1);
        } else if (propertyClass.getClassType().equals("StaticList")) {
            newValue = this.computeNewStaticListValue((StaticListClass)propertyClass, object, propertyName, xcontext);
        }
        return newValue;
    }

    private java.lang.Object computeNewStaticListValue(StaticListClass listClass, BaseObject object, String propertyName, XWikiContext xcontext) {
        java.lang.Object newValue = null;
        if (!listClass.isMultiSelect()) {
            List items = listClass.getList(xcontext);
            int pos = items.indexOf(object.getStringValue(propertyName));
            newValue = pos != -1 ? (pos == items.size() - 1 ? items.get(0) : items.get(pos + 1)) : (items.size() <= 2 ? items.get(items.size() - 1) : items.get(1));
        }
        return newValue;
    }

    private Response buildResponse(XWikiDocument document, String propertyName, XWikiContext xcontext) {
        BaseObject baseObject = document.getXObject(USER_REFERENCE);
        Object object = this.factory.toRestObject(this.uriInfo.getBaseUri(), new Document(document, xcontext), baseObject, false, false);
        for (Property p : object.getProperties()) {
            if (!p.getName().equals(propertyName)) continue;
            return Response.status((Response.Status)Response.Status.ACCEPTED).entity((java.lang.Object)p).build();
        }
        throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
    }
}

