/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.api.Element;
import com.xpn.xwiki.api.XWiki;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.BaseProperty;
import com.xpn.xwiki.objects.classes.BaseClass;
import com.xpn.xwiki.objects.classes.ListClass;
import com.xpn.xwiki.objects.classes.PropertyClass;
import java.net.URI;
import java.util.Calendar;
import java.util.Date;
import java.util.Formatter;
import java.util.List;
import javax.ws.rs.core.UriBuilder;
import org.suigeneris.jrcs.rcs.Version;
import org.xwiki.rest.Utils;
import org.xwiki.rest.model.jaxb.Attachment;
import org.xwiki.rest.model.jaxb.Attribute;
import org.xwiki.rest.model.jaxb.Class;
import org.xwiki.rest.model.jaxb.Comment;
import org.xwiki.rest.model.jaxb.HistorySummary;
import org.xwiki.rest.model.jaxb.Link;
import org.xwiki.rest.model.jaxb.Object;
import org.xwiki.rest.model.jaxb.ObjectFactory;
import org.xwiki.rest.model.jaxb.ObjectSummary;
import org.xwiki.rest.model.jaxb.Page;
import org.xwiki.rest.model.jaxb.PageSummary;
import org.xwiki.rest.model.jaxb.Property;
import org.xwiki.rest.model.jaxb.Space;
import org.xwiki.rest.model.jaxb.Translation;
import org.xwiki.rest.model.jaxb.Translations;
import org.xwiki.rest.model.jaxb.Wiki;
import org.xwiki.rest.model.jaxb.Xwiki;
import org.xwiki.rest.resources.ModificationsResource;
import org.xwiki.rest.resources.SyntaxesResource;
import org.xwiki.rest.resources.attachments.AttachmentResource;
import org.xwiki.rest.resources.attachments.AttachmentVersionResource;
import org.xwiki.rest.resources.attachments.AttachmentsAtPageVersionResource;
import org.xwiki.rest.resources.attachments.AttachmentsResource;
import org.xwiki.rest.resources.classes.ClassPropertiesResource;
import org.xwiki.rest.resources.classes.ClassPropertyResource;
import org.xwiki.rest.resources.classes.ClassResource;
import org.xwiki.rest.resources.classes.ClassesResource;
import org.xwiki.rest.resources.comments.CommentsResource;
import org.xwiki.rest.resources.comments.CommentsVersionResource;
import org.xwiki.rest.resources.objects.AllObjectsForClassNameResource;
import org.xwiki.rest.resources.objects.ObjectAtPageVersionResource;
import org.xwiki.rest.resources.objects.ObjectPropertiesAtPageVersionResource;
import org.xwiki.rest.resources.objects.ObjectPropertiesResource;
import org.xwiki.rest.resources.objects.ObjectPropertyAtPageVersionResource;
import org.xwiki.rest.resources.objects.ObjectPropertyResource;
import org.xwiki.rest.resources.objects.ObjectResource;
import org.xwiki.rest.resources.objects.ObjectsAtPageVersionResource;
import org.xwiki.rest.resources.objects.ObjectsResource;
import org.xwiki.rest.resources.pages.PageChildrenResource;
import org.xwiki.rest.resources.pages.PageHistoryResource;
import org.xwiki.rest.resources.pages.PageResource;
import org.xwiki.rest.resources.pages.PageTagsResource;
import org.xwiki.rest.resources.pages.PageTranslationHistoryResource;
import org.xwiki.rest.resources.pages.PageTranslationResource;
import org.xwiki.rest.resources.pages.PageTranslationVersionResource;
import org.xwiki.rest.resources.pages.PageVersionResource;
import org.xwiki.rest.resources.pages.PagesResource;
import org.xwiki.rest.resources.spaces.SpaceResource;
import org.xwiki.rest.resources.spaces.SpaceSearchResource;
import org.xwiki.rest.resources.spaces.SpacesResource;
import org.xwiki.rest.resources.wikis.WikiSearchResource;
import org.xwiki.rest.resources.wikis.WikisResource;

public class DomainObjectFactory {
    public static Xwiki createXWikiRoot(ObjectFactory objectFactory, URI baseUri, String version) {
        Xwiki xwiki = objectFactory.createXwiki().withVersion(version);
        String wikisUri = UriBuilder.fromUri((URI)baseUri).path(WikisResource.class).build(new java.lang.Object[0]).toString();
        Link wikisLink = objectFactory.createLink();
        wikisLink.setHref(wikisUri);
        wikisLink.setRel("http://www.xwiki.org/rel/wikis");
        xwiki.getLinks().add(wikisLink);
        String syntaxesUri = UriBuilder.fromUri((URI)baseUri).path(SyntaxesResource.class).build(new java.lang.Object[0]).toString();
        Link syntaxesLink = objectFactory.createLink();
        syntaxesLink.setHref(syntaxesUri);
        syntaxesLink.setRel("http://www.xwiki.org/rel/syntaxes");
        xwiki.getLinks().add(syntaxesLink);
        return xwiki;
    }

    public static Wiki createWiki(ObjectFactory objectFactory, URI baseUri, String wikiName) {
        Wiki wiki = objectFactory.createWiki().withId(wikiName).withName(wikiName);
        String spacesUri = UriBuilder.fromUri((URI)baseUri).path(SpacesResource.class).build(new java.lang.Object[]{wikiName}).toString();
        Link spacesLink = objectFactory.createLink();
        spacesLink.setHref(spacesUri);
        spacesLink.setRel("http://www.xwiki.org/rel/spaces");
        wiki.getLinks().add(spacesLink);
        String classesUri = UriBuilder.fromUri((URI)baseUri).path(ClassesResource.class).build(new java.lang.Object[]{wikiName}).toString();
        Link classesLink = objectFactory.createLink();
        classesLink.setHref(classesUri);
        classesLink.setRel("http://www.xwiki.org/rel/classes");
        wiki.getLinks().add(classesLink);
        String modificationsUri = UriBuilder.fromUri((URI)baseUri).path(ModificationsResource.class).build(new java.lang.Object[]{wikiName}).toString();
        Link modificationsLink = objectFactory.createLink();
        modificationsLink.setHref(modificationsUri);
        modificationsLink.setRel("http://www.xwiki.org/rel/modifications");
        wiki.getLinks().add(modificationsLink);
        String searchUri = UriBuilder.fromUri((URI)baseUri).path(WikiSearchResource.class).build(new java.lang.Object[]{wikiName}).toString();
        Link searchLink = objectFactory.createLink();
        searchLink.setHref(searchUri);
        searchLink.setRel("http://www.xwiki.org/rel/search");
        wiki.getLinks().add(searchLink);
        return wiki;
    }

    public static Space createSpace(ObjectFactory objectFactory, URI baseUri, String wikiName, String spaceName, Document home) {
        Space space = objectFactory.createSpace();
        space.setId(String.format("%s:%s", wikiName, spaceName));
        space.setWiki(wikiName);
        space.setName(spaceName);
        if (home != null) {
            space.setHome(home.getPrefixedFullName());
            space.setXwikiRelativeUrl(home.getURL("view"));
            space.setXwikiAbsoluteUrl(home.getExternalURL("view"));
        }
        String pagesUri = UriBuilder.fromUri((URI)baseUri).path(PagesResource.class).build(new java.lang.Object[]{wikiName, spaceName}).toString();
        Link pagesLink = objectFactory.createLink();
        pagesLink.setHref(pagesUri);
        pagesLink.setRel("http://www.xwiki.org/rel/pages");
        space.getLinks().add(pagesLink);
        if (home != null) {
            String homeUri = UriBuilder.fromUri((URI)baseUri).path(PageResource.class).build(new java.lang.Object[]{wikiName, spaceName, home.getName()}).toString();
            Link homeLink = objectFactory.createLink();
            homeLink.setHref(homeUri);
            homeLink.setRel("http://www.xwiki.org/rel/home");
            space.getLinks().add(homeLink);
        }
        String searchUri = UriBuilder.fromUri((URI)baseUri).path(SpaceSearchResource.class).build(new java.lang.Object[]{wikiName, spaceName}).toString();
        Link searchLink = objectFactory.createLink();
        searchLink.setHref(searchUri);
        searchLink.setRel("http://www.xwiki.org/rel/search");
        space.getLinks().add(searchLink);
        return space;
    }

    public static Translations createTranslations(ObjectFactory objectFactory, URI baseUri, Document doc) throws XWikiException {
        Translations translations = objectFactory.createTranslations();
        List languages = doc.getTranslationList();
        if (!languages.isEmpty() && !doc.getDefaultLanguage().equals("")) {
            translations.setDefault(doc.getDefaultLanguage());
            Translation translation = objectFactory.createTranslation();
            translation.setLanguage(doc.getDefaultLanguage());
            String pageTranslationUri = UriBuilder.fromUri((URI)baseUri).path(PageResource.class).build(new java.lang.Object[]{doc.getWiki(), doc.getSpace(), doc.getName()}).toString();
            Link pageTranslationLink = objectFactory.createLink();
            pageTranslationLink.setHref(pageTranslationUri);
            pageTranslationLink.setRel("http://www.xwiki.org/rel/page");
            translation.getLinks().add(pageTranslationLink);
            String historyUri = UriBuilder.fromUri((URI)baseUri).path(PageHistoryResource.class).build(new java.lang.Object[]{doc.getWiki(), doc.getSpace(), doc.getName()}).toString();
            Link historyLink = objectFactory.createLink();
            historyLink.setHref(historyUri);
            historyLink.setRel("http://www.xwiki.org/rel/history");
            translation.getLinks().add(historyLink);
            translations.getTranslations().add(translation);
        }
        for (String language : languages) {
            Translation translation = objectFactory.createTranslation();
            translation.setLanguage(language);
            String pageTranslationUri = UriBuilder.fromUri((URI)baseUri).path(PageTranslationResource.class).build(new java.lang.Object[]{doc.getWiki(), doc.getSpace(), doc.getName(), language}).toString();
            Link pageTranslationLink = objectFactory.createLink();
            pageTranslationLink.setHref(pageTranslationUri);
            pageTranslationLink.setRel("http://www.xwiki.org/rel/page");
            translation.getLinks().add(pageTranslationLink);
            String historyUri = UriBuilder.fromUri((URI)baseUri).path(PageTranslationHistoryResource.class).build(new java.lang.Object[]{doc.getWiki(), doc.getSpace(), doc.getName(), language}).toString();
            Link historyLink = objectFactory.createLink();
            historyLink.setHref(historyUri);
            historyLink.setRel("http://www.xwiki.org/rel/history");
            translation.getLinks().add(historyLink);
            translations.getTranslations().add(translation);
        }
        return translations;
    }

    private static void fillPageSummary(PageSummary pageSummary, ObjectFactory objectFactory, URI baseUri, Document doc, boolean useVersion, XWiki xwikiApi) throws XWikiException {
        com.xpn.xwiki.api.Object tagsObject;
        pageSummary.setWiki(doc.getWiki());
        pageSummary.setFullName(doc.getFullName());
        pageSummary.setId(doc.getPrefixedFullName());
        pageSummary.setSpace(doc.getSpace());
        pageSummary.setName(doc.getName());
        pageSummary.setTitle(doc.getDisplayTitle());
        pageSummary.setXwikiRelativeUrl(doc.getURL("view"));
        pageSummary.setXwikiAbsoluteUrl(doc.getExternalURL("view"));
        pageSummary.setTranslations(DomainObjectFactory.createTranslations(objectFactory, baseUri, doc));
        pageSummary.setSyntax(doc.getSyntaxId());
        Document parent = Utils.getParentDocument(doc, xwikiApi);
        pageSummary.setParent(doc.getParent());
        if (parent != null && !parent.isNew()) {
            pageSummary.setParentId(parent.getPrefixedFullName());
        } else {
            pageSummary.setParentId("");
        }
        String spaceUri = UriBuilder.fromUri((URI)baseUri).path(SpaceResource.class).build(new java.lang.Object[]{doc.getWiki(), doc.getSpace()}).toString();
        Link spaceLink = objectFactory.createLink();
        spaceLink.setHref(spaceUri);
        spaceLink.setRel("http://www.xwiki.org/rel/space");
        pageSummary.getLinks().add(spaceLink);
        if (parent != null) {
            String parentUri = UriBuilder.fromUri((URI)baseUri).path(PageResource.class).build(new java.lang.Object[]{parent.getWiki(), parent.getSpace(), parent.getName()}).toString();
            Link parentLink = objectFactory.createLink();
            parentLink.setHref(parentUri);
            parentLink.setRel("http://www.xwiki.org/rel/parent");
            pageSummary.getLinks().add(parentLink);
        }
        String historyUri = UriBuilder.fromUri((URI)baseUri).path(PageHistoryResource.class).build(new java.lang.Object[]{doc.getWiki(), doc.getSpace(), doc.getName()}).toString();
        Link historyLink = objectFactory.createLink();
        historyLink.setHref(historyUri);
        historyLink.setRel("http://www.xwiki.org/rel/history");
        pageSummary.getLinks().add(historyLink);
        if (!doc.getChildren().isEmpty()) {
            String pageChildrenUri = UriBuilder.fromUri((URI)baseUri).path(PageChildrenResource.class).build(new java.lang.Object[]{doc.getWiki(), doc.getSpace(), doc.getName()}).toString();
            Link pageChildrenLink = objectFactory.createLink();
            pageChildrenLink.setHref(pageChildrenUri);
            pageChildrenLink.setRel("http://www.xwiki.org/rel/children");
            pageSummary.getLinks().add(pageChildrenLink);
        }
        if (!doc.getComments().isEmpty()) {
            String commentsUri = useVersion ? UriBuilder.fromUri((URI)baseUri).path(CommentsVersionResource.class).build(new java.lang.Object[]{doc.getWiki(), doc.getSpace(), doc.getName(), doc.getVersion()}).toString() : UriBuilder.fromUri((URI)baseUri).path(CommentsResource.class).build(new java.lang.Object[]{doc.getWiki(), doc.getSpace(), doc.getName()}).toString();
            Link commentsLink = objectFactory.createLink();
            commentsLink.setHref(commentsUri);
            commentsLink.setRel("http://www.xwiki.org/rel/comments");
            pageSummary.getLinks().add(commentsLink);
        }
        if (!doc.getAttachmentList().isEmpty()) {
            String attachmentsUri = useVersion ? UriBuilder.fromUri((URI)baseUri).path(AttachmentsAtPageVersionResource.class).build(new java.lang.Object[]{doc.getWiki(), doc.getSpace(), doc.getName(), doc.getVersion()}).toString() : UriBuilder.fromUri((URI)baseUri).path(AttachmentsResource.class).build(new java.lang.Object[]{doc.getWiki(), doc.getSpace(), doc.getName()}).toString();
            Link attachmentsLink = objectFactory.createLink();
            attachmentsLink.setHref(attachmentsUri);
            attachmentsLink.setRel("http://www.xwiki.org/rel/attachments");
            pageSummary.getLinks().add(attachmentsLink);
        }
        if (!doc.getxWikiObjects().keySet().isEmpty()) {
            String objectsUri = useVersion ? UriBuilder.fromUri((URI)baseUri).path(ObjectsAtPageVersionResource.class).build(new java.lang.Object[]{doc.getWiki(), doc.getSpace(), doc.getName(), doc.getVersion()}).toString() : UriBuilder.fromUri((URI)baseUri).path(ObjectsResource.class).build(new java.lang.Object[]{doc.getWiki(), doc.getSpace(), doc.getName()}).toString();
            Link objectsLink = objectFactory.createLink();
            objectsLink.setHref(objectsUri);
            objectsLink.setRel("http://www.xwiki.org/rel/objects");
            pageSummary.getLinks().add(objectsLink);
        }
        if ((tagsObject = doc.getObject("XWiki.TagClass", 0)) != null && tagsObject.getProperty("tags") != null) {
            String tagsUri = UriBuilder.fromUri((URI)baseUri).path(PageTagsResource.class).build(new java.lang.Object[]{doc.getWiki(), doc.getSpace(), doc.getName()}).toString();
            Link tagsLink = objectFactory.createLink();
            tagsLink.setHref(tagsUri);
            tagsLink.setRel("http://www.xwiki.org/rel/tags");
            pageSummary.getLinks().add(tagsLink);
        }
        String syntaxesUri = UriBuilder.fromUri((URI)baseUri).path(SyntaxesResource.class).build(new java.lang.Object[0]).toString();
        Link syntaxesLink = objectFactory.createLink();
        syntaxesLink.setHref(syntaxesUri);
        syntaxesLink.setRel("http://www.xwiki.org/rel/syntaxes");
        pageSummary.getLinks().add(syntaxesLink);
    }

    public static PageSummary createPageSummary(ObjectFactory objectFactory, URI baseUri, Document doc, XWiki xwikiApi) throws XWikiException {
        PageSummary pageSummary = objectFactory.createPageSummary();
        DomainObjectFactory.fillPageSummary(pageSummary, objectFactory, baseUri, doc, false, xwikiApi);
        String pageUri = UriBuilder.fromUri((URI)baseUri).path(PageResource.class).build(new java.lang.Object[]{doc.getWiki(), doc.getSpace(), doc.getName()}).toString();
        Link pageLink = objectFactory.createLink();
        pageLink.setHref(pageUri);
        pageLink.setRel("http://www.xwiki.org/rel/page");
        pageSummary.getLinks().add(pageLink);
        return pageSummary;
    }

    public static Page createPage(ObjectFactory objectFactory, URI baseUri, URI self, Document doc, boolean useVersion, XWiki xwikiApi) throws XWikiException {
        com.xpn.xwiki.api.Class xwikiClass;
        Page page = objectFactory.createPage();
        DomainObjectFactory.fillPageSummary((PageSummary)page, objectFactory, baseUri, doc, useVersion, xwikiApi);
        page.setVersion(doc.getVersion());
        page.setMajorVersion(doc.getRCSVersion().at(0));
        page.setMinorVersion(doc.getRCSVersion().at(1));
        page.setLanguage(doc.getLanguage());
        page.setCreator(doc.getCreator());
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(doc.getCreationDate());
        page.setCreated(calendar);
        page.setModifier(doc.getContentAuthor());
        calendar = Calendar.getInstance();
        calendar.setTime(doc.getContentUpdateDate());
        page.setModified(calendar);
        page.setContent(doc.getContent());
        if (self != null) {
            Link pageLink = objectFactory.createLink();
            pageLink.setHref(self.toString());
            pageLink.setRel("self");
            page.getLinks().add(pageLink);
        }
        if ((xwikiClass = doc.getxWikiClass()) != null) {
            String classUri = UriBuilder.fromUri((URI)baseUri).path(ClassResource.class).build(new java.lang.Object[]{doc.getWiki(), xwikiClass.getName()}).toString();
            Link classLink = objectFactory.createLink();
            classLink.setHref(classUri);
            classLink.setRel("http://www.xwiki.org/rel/class");
            page.getLinks().add(classLink);
        }
        return page;
    }

    public static HistorySummary createHistorySummary(ObjectFactory objectFactory, URI baseUri, String wikiName, String spaceName, String pageName, String language, Version version, String modifier, Date modified) {
        HistorySummary historySummary = objectFactory.createHistorySummary();
        String pageId = Utils.getPageId(wikiName, spaceName, pageName);
        historySummary.setPageId(pageId);
        historySummary.setWiki(wikiName);
        historySummary.setSpace(spaceName);
        historySummary.setName(pageName);
        historySummary.setVersion(version.toString());
        historySummary.setMajorVersion(version.at(0));
        historySummary.setMinorVersion(version.at(1));
        historySummary.setModifier(modifier);
        historySummary.setLanguage(language);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(modified);
        historySummary.setModified(calendar);
        if (language == null) {
            String pageUri = UriBuilder.fromUri((URI)baseUri).path(PageVersionResource.class).build(new java.lang.Object[]{wikiName, spaceName, pageName, version}).toString();
            Link pageLink = objectFactory.createLink();
            pageLink.setHref(pageUri);
            pageLink.setRel("http://www.xwiki.org/rel/page");
            historySummary.getLinks().add(pageLink);
        } else {
            String pageUri = UriBuilder.fromUri((URI)baseUri).path(PageTranslationVersionResource.class).build(new java.lang.Object[]{wikiName, spaceName, pageName, language, version}).toString();
            Link pageLink = objectFactory.createLink();
            pageLink.setHref(pageUri);
            pageLink.setRel("http://www.xwiki.org/rel/page");
            historySummary.getLinks().add(pageLink);
        }
        return historySummary;
    }

    private static void fillAttachment(Attachment attachment, ObjectFactory objectFactory, URI baseUri, com.xpn.xwiki.api.Attachment xwikiAttachment, String xwikiRelativeUrl, String xwikiAbsoluteUrl) {
        Document doc = xwikiAttachment.getDocument();
        attachment.setId(String.format("%s@%s", doc.getPrefixedFullName(), xwikiAttachment.getFilename()));
        attachment.setName(xwikiAttachment.getFilename());
        attachment.setSize(xwikiAttachment.getFilesize());
        attachment.setVersion(xwikiAttachment.getVersion());
        attachment.setPageId(doc.getPrefixedFullName());
        attachment.setPageVersion(doc.getVersion());
        attachment.setMimeType(xwikiAttachment.getMimeType());
        attachment.setAuthor(xwikiAttachment.getAuthor());
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(xwikiAttachment.getDate());
        attachment.setDate(calendar);
        attachment.setXwikiRelativeUrl(xwikiRelativeUrl);
        attachment.setXwikiAbsoluteUrl(xwikiAbsoluteUrl);
        String pageUri = UriBuilder.fromUri((URI)baseUri).path(PageResource.class).build(new java.lang.Object[]{doc.getWiki(), doc.getSpace(), doc.getName()}).toString();
        Link pageLink = objectFactory.createLink();
        pageLink.setHref(pageUri);
        pageLink.setRel("http://www.xwiki.org/rel/page");
        attachment.getLinks().add(pageLink);
    }

    public static Attachment createAttachment(ObjectFactory objectFactory, URI baseUri, com.xpn.xwiki.api.Attachment xwikiAttachment, String xwikiRelativeUrl, String xwikiAbsoluteUrl) {
        Attachment attachment = objectFactory.createAttachment();
        DomainObjectFactory.fillAttachment(attachment, objectFactory, baseUri, xwikiAttachment, xwikiRelativeUrl, xwikiAbsoluteUrl);
        Document doc = xwikiAttachment.getDocument();
        String attachmentUri = UriBuilder.fromUri((URI)baseUri).path(AttachmentResource.class).build(new java.lang.Object[]{doc.getWiki(), doc.getSpace(), doc.getName(), xwikiAttachment.getFilename()}).toString();
        Link attachmentLink = objectFactory.createLink();
        attachmentLink.setHref(attachmentUri);
        attachmentLink.setRel("http://www.xwiki.org/rel/attachmentData");
        attachment.getLinks().add(attachmentLink);
        return attachment;
    }

    public static Attachment createAttachmentAtVersion(ObjectFactory objectFactory, URI baseUri, com.xpn.xwiki.api.Attachment xwikiAttachment, String xwikiRelativeUrl, String xwikiAbsoluteUrl) {
        Attachment attachment = new Attachment();
        DomainObjectFactory.fillAttachment(attachment, objectFactory, baseUri, xwikiAttachment, xwikiRelativeUrl, xwikiAbsoluteUrl);
        Document doc = xwikiAttachment.getDocument();
        String attachmentUri = UriBuilder.fromUri((URI)baseUri).path(AttachmentVersionResource.class).build(new java.lang.Object[]{doc.getWiki(), doc.getSpace(), doc.getName(), xwikiAttachment.getFilename(), xwikiAttachment.getVersion()}).toString();
        Link attachmentLink = objectFactory.createLink();
        attachmentLink.setHref(attachmentUri);
        attachmentLink.setRel("http://www.xwiki.org/rel/attachmentData");
        attachment.getLinks().add(attachmentLink);
        return attachment;
    }

    public static Comment createComment(ObjectFactory objectFactory, URI baseUri, Document doc, com.xpn.xwiki.api.Object xwikiComment) {
        Comment comment = objectFactory.createComment();
        comment.setId(xwikiComment.getNumber());
        com.xpn.xwiki.api.Property property = xwikiComment.getProperty("author");
        if (property != null) {
            comment.setAuthor((String)property.getValue());
        }
        if ((property = xwikiComment.getProperty("date")) != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime((Date)property.getValue());
            comment.setDate(calendar);
        }
        if ((property = xwikiComment.getProperty("highlight")) != null) {
            comment.setHighlight((String)property.getValue());
        }
        if ((property = xwikiComment.getProperty("comment")) != null) {
            comment.setText((String)property.getValue());
        }
        if ((property = xwikiComment.getProperty("replyto")) != null) {
            comment.setReplyTo((Integer)property.getValue());
        }
        String pageUri = UriBuilder.fromUri((URI)baseUri).path(PageResource.class).build(new java.lang.Object[]{doc.getWiki(), doc.getSpace(), doc.getName()}).toString();
        Link pageLink = objectFactory.createLink();
        pageLink.setHref(pageUri);
        pageLink.setRel("http://www.xwiki.org/rel/page");
        comment.getLinks().add(pageLink);
        return comment;
    }

    private static void fillObjectSummary(ObjectSummary objectSummary, ObjectFactory objectFactory, URI baseUri, Document doc, BaseObject xwikiObject) throws XWikiException {
        objectSummary.setId(String.format("%s:%s", doc.getPrefixedFullName(), xwikiObject.getGuid()));
        objectSummary.setGuid(xwikiObject.getGuid());
        objectSummary.setPageId(doc.getPrefixedFullName());
        objectSummary.setWiki(doc.getWiki());
        objectSummary.setSpace(doc.getSpace());
        objectSummary.setPageName(doc.getName());
        objectSummary.setClassName(xwikiObject.getClassName());
        objectSummary.setNumber(xwikiObject.getNumber());
        String[] propertyNames = xwikiObject.getPropertyNames();
        if (propertyNames.length > 0) {
            objectSummary.setHeadline(xwikiObject.get(propertyNames[0]).toFormString());
        }
    }

    public static ObjectSummary createObjectSummary(ObjectFactory objectFactory, URI baseUri, XWikiContext xwikiContext, Document doc, BaseObject xwikiObject, boolean useVersion) throws XWikiException {
        ObjectSummary objectSummary = objectFactory.createObjectSummary();
        DomainObjectFactory.fillObjectSummary(objectSummary, objectFactory, baseUri, doc, xwikiObject);
        Link objectLink = DomainObjectFactory.getObjectLink(objectFactory, baseUri, doc, xwikiObject, useVersion, "http://www.xwiki.org/rel/object");
        objectSummary.getLinks().add(objectLink);
        String propertiesUri = useVersion ? UriBuilder.fromUri((URI)baseUri).path(ObjectPropertiesAtPageVersionResource.class).build(new java.lang.Object[]{doc.getWiki(), doc.getSpace(), doc.getName(), doc.getVersion(), xwikiObject.getClassName(), xwikiObject.getNumber()}).toString() : UriBuilder.fromUri((URI)baseUri).path(ObjectPropertiesResource.class).build(new java.lang.Object[]{doc.getWiki(), doc.getSpace(), doc.getName(), xwikiObject.getClassName(), xwikiObject.getNumber()}).toString();
        Link propertyLink = objectFactory.createLink();
        propertyLink.setHref(propertiesUri);
        propertyLink.setRel("http://www.xwiki.org/rel/properties");
        objectSummary.getLinks().add(propertyLink);
        return objectSummary;
    }

    public static Object createObject(ObjectFactory objectFactory, URI baseUri, XWikiContext xwikiContext, Document doc, BaseObject xwikiObject, boolean useVersion) throws XWikiException {
        Object object = objectFactory.createObject();
        DomainObjectFactory.fillObjectSummary((ObjectSummary)object, objectFactory, baseUri, doc, xwikiObject);
        BaseClass xwikiClass = xwikiObject.getXClass(xwikiContext);
        for (java.lang.Object propertyClassObject : xwikiClass.getProperties()) {
            ListClass listClass;
            List allowedValueList;
            PropertyClass propertyClass = (PropertyClass)propertyClassObject;
            Property property = objectFactory.createProperty();
            for (java.lang.Object o : propertyClass.getProperties()) {
                BaseProperty baseProperty = (BaseProperty)o;
                Attribute attribute = objectFactory.createAttribute();
                attribute.setName(baseProperty.getName());
                if (baseProperty.getValue() != null) {
                    attribute.setValue(baseProperty.getValue().toString());
                } else {
                    attribute.setValue("");
                }
                property.getAttributes().add(attribute);
            }
            if (propertyClass instanceof ListClass && !(allowedValueList = (listClass = (ListClass)propertyClass).getList(xwikiContext)).isEmpty()) {
                Formatter f = new Formatter();
                for (int i = 0; i < allowedValueList.size(); ++i) {
                    if (i != allowedValueList.size() - 1) {
                        f.format("%s,", allowedValueList.get(i).toString());
                        continue;
                    }
                    f.format("%s", allowedValueList.get(i).toString());
                }
                Attribute attribute = objectFactory.createAttribute();
                attribute.setName("allowedValues");
                attribute.setValue(f.toString());
                property.getAttributes().add(attribute);
            }
            property.setName(propertyClass.getName());
            property.setType(propertyClass.getClassType());
            if (xwikiObject.get(propertyClass.getName()) != null) {
                property.setValue(xwikiObject.get(propertyClass.getName()).toFormString());
            } else {
                property.setValue("");
            }
            String propertyUri = useVersion ? UriBuilder.fromUri((URI)baseUri).path(ObjectPropertyAtPageVersionResource.class).build(new java.lang.Object[]{doc.getWiki(), doc.getSpace(), doc.getName(), doc.getVersion(), xwikiObject.getClassName(), xwikiObject.getNumber(), propertyClass.getName()}).toString() : UriBuilder.fromUri((URI)baseUri).path(ObjectPropertyResource.class).build(new java.lang.Object[]{doc.getWiki(), doc.getSpace(), doc.getName(), xwikiObject.getClassName(), xwikiObject.getNumber(), propertyClass.getName()}).toString();
            Link propertyLink = objectFactory.createLink();
            propertyLink.setHref(propertyUri);
            propertyLink.setRel("self");
            property.getLinks().add(propertyLink);
            object.getProperties().add(property);
        }
        Link objectLink = DomainObjectFactory.getObjectLink(objectFactory, baseUri, doc, xwikiObject, useVersion, "self");
        object.getLinks().add(objectLink);
        return object;
    }

    private static Link getObjectLink(ObjectFactory objectFactory, URI baseUri, Document doc, BaseObject xwikiObject, boolean useVersion, String relation) {
        String objectUri = useVersion ? UriBuilder.fromUri((URI)baseUri).path(ObjectAtPageVersionResource.class).build(new java.lang.Object[]{doc.getWiki(), doc.getSpace(), doc.getName(), doc.getVersion(), xwikiObject.getClassName(), xwikiObject.getNumber()}).toString() : UriBuilder.fromUri((URI)baseUri).path(ObjectResource.class).build(new java.lang.Object[]{doc.getWiki(), doc.getSpace(), doc.getName(), xwikiObject.getClassName(), xwikiObject.getNumber()}).toString();
        Link objectLink = objectFactory.createLink();
        objectLink.setHref(objectUri);
        objectLink.setRel(relation);
        return objectLink;
    }

    public static Class createClass(ObjectFactory objectFactory, URI baseUri, String wikiName, com.xpn.xwiki.api.Class xwikiClass) {
        Class clazz = objectFactory.createClass();
        clazz.setId(xwikiClass.getName());
        clazz.setName(xwikiClass.getName());
        for (Element xwikiPropertyClassObject : xwikiClass.getProperties()) {
            com.xpn.xwiki.api.PropertyClass xwikiPropertyClass = (com.xpn.xwiki.api.PropertyClass)xwikiPropertyClassObject;
            Property property = objectFactory.createProperty();
            property.setName(xwikiPropertyClass.getName());
            property.setType(xwikiPropertyClass.getxWikiClass().getName());
            for (Element xwikiPropertyObject : xwikiPropertyClass.getProperties()) {
                com.xpn.xwiki.api.Property xwikiProperty = (com.xpn.xwiki.api.Property)xwikiPropertyObject;
                java.lang.Object value = xwikiProperty.getValue();
                Attribute attribute = objectFactory.createAttribute();
                attribute.setName(xwikiProperty.getName());
                if (value != null) {
                    attribute.setValue(value.toString());
                } else {
                    attribute.setValue("");
                }
                property.getAttributes().add(attribute);
            }
            String propertyUri = UriBuilder.fromUri((URI)baseUri).path(ClassPropertyResource.class).build(new java.lang.Object[]{wikiName, xwikiClass.getName(), xwikiPropertyClass.getName()}).toString();
            Link propertyLink = objectFactory.createLink();
            propertyLink.setHref(propertyUri);
            propertyLink.setRel("self");
            property.getLinks().add(propertyLink);
            clazz.getProperties().add(property);
        }
        String classUri = UriBuilder.fromUri((URI)baseUri).path(ClassResource.class).build(new java.lang.Object[]{wikiName, xwikiClass.getName()}).toString();
        Link classLink = objectFactory.createLink();
        classLink.setHref(classUri);
        classLink.setRel("self");
        clazz.getLinks().add(classLink);
        String propertiesUri = UriBuilder.fromUri((URI)baseUri).path(ClassPropertiesResource.class).build(new java.lang.Object[]{wikiName, xwikiClass.getName()}).toString();
        Link propertyLink = objectFactory.createLink();
        propertyLink.setHref(propertiesUri);
        propertyLink.setRel("http://www.xwiki.org/rel/properties");
        clazz.getLinks().add(propertyLink);
        String objectsUri = UriBuilder.fromUri((URI)baseUri).path(AllObjectsForClassNameResource.class).build(new java.lang.Object[]{wikiName, xwikiClass.getName()}).toString();
        Link objectsLink = objectFactory.createLink();
        objectsLink.setHref(objectsUri);
        objectsLink.setRel("http://www.xwiki.org/rel/objects");
        clazz.getLinks().add(objectsLink);
        return clazz;
    }
}

