/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.resources.classes;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Class;
import java.net.URI;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.xwiki.component.annotation.Component;
import org.xwiki.rest.DomainObjectFactory;
import org.xwiki.rest.Utils;
import org.xwiki.rest.XWikiResource;
import org.xwiki.rest.model.jaxb.Link;
import org.xwiki.rest.model.jaxb.Property;
import org.xwiki.rest.resources.classes.ClassResource;

@Component(value="org.xwiki.rest.resources.classes.ClassPropertyResource")
@Path(value="/wikis/{wikiName}/classes/{className}/properties/{propertyName}")
public class ClassPropertyResource
extends XWikiResource {
    @GET
    public Property getClassProperty(@PathParam(value="wikiName") String wikiName, @PathParam(value="className") String className, @PathParam(value="propertyName") String propertyName) throws XWikiException {
        String database = Utils.getXWikiContext(this.componentManager).getDatabase();
        try {
            Utils.getXWikiContext(this.componentManager).setDatabase(wikiName);
            Class xwikiClass = Utils.getXWikiApi(this.componentManager).getClass(className);
            if (xwikiClass == null) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            org.xwiki.rest.model.jaxb.Class clazz = DomainObjectFactory.createClass(this.objectFactory, this.uriInfo.getBaseUri(), wikiName, xwikiClass);
            for (Property property : clazz.getProperties()) {
                if (!property.getName().equals(propertyName)) continue;
                String classUri = UriBuilder.fromUri((URI)this.uriInfo.getBaseUri()).path(ClassResource.class).build(new Object[]{wikiName, xwikiClass.getName()}).toString();
                Link classLink = this.objectFactory.createLink();
                classLink.setHref(classUri);
                classLink.setRel("http://www.xwiki.org/rel/class");
                property.getLinks().add(classLink);
                Property property2 = property;
                return property2;
            }
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        finally {
            Utils.getXWikiContext(this.componentManager).setDatabase(database);
        }
    }
}

