/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.resources.tags;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Document;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.xwiki.component.annotation.Component;
import org.xwiki.query.QueryException;
import org.xwiki.rest.DomainObjectFactory;
import org.xwiki.rest.RangeIterable;
import org.xwiki.rest.Utils;
import org.xwiki.rest.XWikiResource;
import org.xwiki.rest.model.jaxb.Pages;

@Component(value="org.xwiki.rest.resources.tags.PagesForTagsResource")
@Path(value="/wikis/{wikiName}/tags/{tagNames}")
public class PagesForTagsResource
extends XWikiResource {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    public Pages getTags(@PathParam(value="wikiName") String wikiName, @PathParam(value="tagNames") String tagNames, @QueryParam(value="start") @DefaultValue(value="0") Integer start, @QueryParam(value="number") @DefaultValue(value="-1") Integer number) throws XWikiException, QueryException {
        String database = Utils.getXWikiContext(this.componentManager).getDatabase();
        Pages pages = this.objectFactory.createPages();
        try {
            Utils.getXWikiContext(this.componentManager).setDatabase(wikiName);
            String[] tagNamesArray = tagNames.split(",");
            ArrayList<String> documentNames = new ArrayList<String>();
            for (String tagName : tagNamesArray) {
                List<String> documentNamesForTag = this.getDocumentsWithTag(tagName);
                for (String documentName : documentNamesForTag) {
                    if (documentNames.contains(documentName)) continue;
                    documentNames.add(documentName);
                }
            }
            RangeIterable ri = new RangeIterable(documentNames, start, number);
            for (String documentName : ri) {
                Document doc = Utils.getXWikiApi(this.componentManager).getDocument(documentName);
                if (doc == null) continue;
                pages.getPageSummaries().add(DomainObjectFactory.createPageSummary(this.objectFactory, this.uriInfo.getBaseUri(), doc, Utils.getXWikiApi(this.componentManager)));
            }
        }
        finally {
            Utils.getXWikiContext(this.componentManager).setDatabase(database);
        }
        return pages;
    }

    private List<String> getDocumentsWithTag(String tag) throws QueryException {
        String query = "select doc.fullName from XWikiDocument as doc, BaseObject as obj, DBStringListProperty as prop where obj.name=doc.fullName and obj.className='XWiki.TagClass' and obj.id=prop.id.id and prop.id.name='tags' and :tag in elements(prop.list) order by doc.name asc";
        List documentsWithTag = this.queryManager.createQuery(query, "hql").bindValue("tag", (Object)tag).execute();
        return documentsWithTag;
    }
}

