/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal;

import java.io.InputStream;
import java.util.logging.LogManager;
import javax.servlet.ServletException;
import org.restlet.Application;
import org.restlet.Context;
import org.restlet.ext.servlet.ServerServlet;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rest.internal.ComponentsObjectFactory;
import org.xwiki.rest.internal.XWikiRestletJaxRsApplication;

public class XWikiRestletServlet
extends ServerServlet {
    private static final String JAVA_LOGGING_PROPERTY_FILE = "java-logging.properties";
    private static final long serialVersionUID = 9148448182654390153L;

    protected Application createApplication(Context context) {
        Application application = super.createApplication(context);
        Context applicationContext = application.getContext();
        ComponentManager componentManager = this.getComponentManager(context);
        applicationContext.getAttributes().put("xwikiComponentManager", componentManager);
        if (application instanceof XWikiRestletJaxRsApplication) {
            XWikiRestletJaxRsApplication jaxrsApplication = (XWikiRestletJaxRsApplication)application;
            jaxrsApplication.setObjectFactory(new ComponentsObjectFactory(componentManager));
        } else {
            this.log("The Restlet application is not an instance of XWikiRestletJaxRsApplication. Please check your web.xml");
        }
        return application;
    }

    public void init() throws ServletException {
        super.init();
        try {
            InputStream is = this.getServletContext().getResourceAsStream(String.format("/WEB-INF/%s", JAVA_LOGGING_PROPERTY_FILE));
            if (is == null) {
                is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(JAVA_LOGGING_PROPERTY_FILE);
            }
            if (is != null) {
                LogManager.getLogManager().readConfiguration(is);
                is.close();
            }
        }
        catch (Exception e) {
            this.log("Unable to initialize Java logging framework. Using defaults", e);
        }
    }

    private ComponentManager getComponentManager(Context context) {
        ComponentManager result = (ComponentManager)this.getServletContext().getAttribute("org.xwiki.component.manager.ComponentManager");
        try {
            result = (ComponentManager)result.getInstance(ComponentManager.class, "context");
        }
        catch (ComponentLookupException componentLookupException) {
            // empty catch block
        }
        return result;
    }
}

