/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal.resources.attachments;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Attachment;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiDocument;
import java.net.URI;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.xwiki.component.annotation.Component;
import org.xwiki.rest.XWikiResource;
import org.xwiki.rest.XWikiRestException;
import org.xwiki.rest.internal.Utils;
import org.xwiki.rest.internal.resources.BaseAttachmentsResource;
import org.xwiki.rest.resources.attachments.AttachmentResource;

@Component(value="org.xwiki.rest.internal.resources.attachments.AttachmentResourceImpl")
public class AttachmentResourceImpl
extends BaseAttachmentsResource
implements AttachmentResource {
    public Response getAttachment(String wikiName, String spaceName, String pageName, String attachmentName) throws XWikiRestException {
        try {
            XWikiResource.DocumentInfo documentInfo = this.getDocumentInfo(wikiName, spaceName, pageName, null, null, true, false);
            Document doc = documentInfo.getDocument();
            Attachment xwikiAttachment = doc.getAttachment(attachmentName);
            if (xwikiAttachment == null) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            return Response.ok().type(xwikiAttachment.getMimeType()).entity((Object)xwikiAttachment.getContent()).build();
        }
        catch (XWikiException e) {
            throw new XWikiRestException((Throwable)e);
        }
    }

    public Response putAttachment(String wikiName, String spaceName, String pageName, String attachmentName, byte[] content) throws XWikiRestException {
        try {
            XWikiResource.DocumentInfo documentInfo = this.getDocumentInfo(wikiName, spaceName, pageName, null, null, true, true);
            Document doc = documentInfo.getDocument();
            if (!doc.hasAccessLevel("edit", Utils.getXWikiUser(this.componentManager))) {
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            BaseAttachmentsResource.AttachmentInfo attachmentInfo = this.storeAttachment(doc, attachmentName, content);
            if (attachmentInfo.isAlreadyExisting()) {
                return Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)attachmentInfo.getAttachment()).build();
            }
            return Response.created((URI)this.uriInfo.getAbsolutePath()).entity((Object)attachmentInfo.getAttachment()).build();
        }
        catch (XWikiException e) {
            throw new XWikiRestException((Throwable)e);
        }
    }

    public void deleteAttachment(String wikiName, String spaceName, String pageName, String attachmentName) throws XWikiRestException {
        try {
            XWikiResource.DocumentInfo documentInfo = this.getDocumentInfo(wikiName, spaceName, pageName, null, null, true, true);
            Document doc = documentInfo.getDocument();
            if (!doc.hasAccessLevel("edit", Utils.getXWikiUser(this.componentManager))) {
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            Attachment xwikiAttachment = doc.getAttachment(attachmentName);
            if (xwikiAttachment == null) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            XWikiDocument xwikiDocument = Utils.getXWiki(this.componentManager).getDocument(doc.getPrefixedFullName(), Utils.getXWikiContext(this.componentManager));
            XWikiAttachment baseXWikiAttachment = xwikiDocument.getAttachment(attachmentName);
            xwikiDocument.deleteAttachment(baseXWikiAttachment, Utils.getXWikiContext(this.componentManager));
            Utils.getXWiki(this.componentManager).saveDocument(xwikiDocument, Utils.getXWikiContext(this.componentManager));
        }
        catch (XWikiException e) {
            throw new XWikiRestException((Throwable)e);
        }
    }
}

