/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal.resources.classes;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Class;
import java.net.URI;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.xwiki.component.annotation.Component;
import org.xwiki.rest.XWikiResource;
import org.xwiki.rest.XWikiRestException;
import org.xwiki.rest.internal.DomainObjectFactory;
import org.xwiki.rest.internal.Utils;
import org.xwiki.rest.model.jaxb.Link;
import org.xwiki.rest.model.jaxb.Properties;
import org.xwiki.rest.resources.classes.ClassPropertiesResource;
import org.xwiki.rest.resources.classes.ClassResource;

@Component(value="org.xwiki.rest.internal.resources.classes.ClassPropertiesResourceImpl")
public class ClassPropertiesResourceImpl
extends XWikiResource
implements ClassPropertiesResource {
    public Properties getClassProperties(String wikiName, String className) throws XWikiRestException {
        String database = Utils.getXWikiContext(this.componentManager).getDatabase();
        try {
            Utils.getXWikiContext(this.componentManager).setDatabase(wikiName);
            Class xwikiClass = Utils.getXWikiApi(this.componentManager).getClass(className);
            if (xwikiClass == null) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            org.xwiki.rest.model.jaxb.Class clazz = DomainObjectFactory.createClass(this.objectFactory, this.uriInfo.getBaseUri(), wikiName, xwikiClass);
            Properties properties = this.objectFactory.createProperties();
            properties.getProperties().addAll(clazz.getProperties());
            String classUri = UriBuilder.fromUri((URI)this.uriInfo.getBaseUri()).path(ClassResource.class).build(new Object[]{wikiName, xwikiClass.getName()}).toString();
            Link classLink = this.objectFactory.createLink();
            classLink.setHref(classUri);
            classLink.setRel("http://www.xwiki.org/rel/class");
            properties.getLinks().add(classLink);
            Properties properties2 = properties;
            return properties2;
        }
        catch (XWikiException e) {
            throw new XWikiRestException((Throwable)e);
        }
        finally {
            Utils.getXWikiContext(this.componentManager).setDatabase(database);
        }
    }
}

