/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal.resources.wikis;

import com.xpn.xwiki.XWikiException;
import java.net.URI;
import java.util.List;
import javax.ws.rs.core.UriBuilder;
import org.xwiki.component.annotation.Component;
import org.xwiki.rest.XWikiResource;
import org.xwiki.rest.XWikiRestException;
import org.xwiki.rest.internal.DomainObjectFactory;
import org.xwiki.rest.internal.Utils;
import org.xwiki.rest.model.jaxb.Link;
import org.xwiki.rest.model.jaxb.Wikis;
import org.xwiki.rest.resources.wikis.WikisResource;
import org.xwiki.rest.resources.wikis.WikisSearchQueryResource;

@Component(value="org.xwiki.rest.internal.resources.wikis.WikisResourceImpl")
public class WikisResourceImpl
extends XWikiResource
implements WikisResource {
    public Wikis getWikis() throws XWikiRestException {
        try {
            String mainWiki = Utils.getXWikiContext(this.componentManager).getMainXWiki();
            List databaseNames = Utils.getXWiki(this.componentManager).getVirtualWikisDatabaseNames(Utils.getXWikiContext(this.componentManager));
            if (!databaseNames.contains(mainWiki)) {
                databaseNames.add(mainWiki);
            }
            Wikis wikis = this.objectFactory.createWikis();
            for (String databaseName : databaseNames) {
                wikis.getWikis().add(DomainObjectFactory.createWiki(this.objectFactory, this.uriInfo.getBaseUri(), databaseName));
            }
            String queryUri = UriBuilder.fromUri((URI)this.uriInfo.getBaseUri()).path(WikisSearchQueryResource.class).toString();
            Link queryLink = this.objectFactory.createLink();
            queryLink.setHref(queryUri);
            queryLink.setRel("http://www.xwiki.org/rel/query");
            wikis.getLinks().add(queryLink);
            return wikis;
        }
        catch (XWikiException e) {
            throw new XWikiRestException((Throwable)e);
        }
    }
}

