/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal.resources.objects;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.classes.BaseClass;
import java.net.URI;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.xwiki.component.annotation.Component;
import org.xwiki.rest.XWikiResource;
import org.xwiki.rest.XWikiRestException;
import org.xwiki.rest.internal.DomainObjectFactory;
import org.xwiki.rest.internal.RangeIterable;
import org.xwiki.rest.internal.Utils;
import org.xwiki.rest.internal.resources.objects.BaseObjectsResource;
import org.xwiki.rest.model.jaxb.Object;
import org.xwiki.rest.model.jaxb.Objects;
import org.xwiki.rest.model.jaxb.Property;
import org.xwiki.rest.resources.objects.ObjectResource;
import org.xwiki.rest.resources.objects.ObjectsResource;

@Component(value="org.xwiki.rest.internal.resources.objects.ObjectsResourceImpl")
public class ObjectsResourceImpl
extends BaseObjectsResource
implements ObjectsResource {
    public Objects getObjects(String wikiName, String spaceName, String pageName, Integer start, Integer number, Boolean withPrettyNames) throws XWikiRestException {
        try {
            XWikiResource.DocumentInfo documentInfo = this.getDocumentInfo(wikiName, spaceName, pageName, null, null, true, false);
            Document doc = documentInfo.getDocument();
            Objects objects = this.objectFactory.createObjects();
            List<BaseObject> objectList = this.getBaseObjects(doc);
            RangeIterable<BaseObject> ri = new RangeIterable<BaseObject>(objectList, start, number);
            for (BaseObject object : ri) {
                if (object == null) continue;
                objects.getObjectSummaries().add(DomainObjectFactory.createObjectSummary(this.objectFactory, this.uriInfo.getBaseUri(), Utils.getXWikiContext(this.componentManager), doc, object, false, Utils.getXWikiApi(this.componentManager), withPrettyNames));
            }
            return objects;
        }
        catch (XWikiException e) {
            throw new XWikiRestException((Throwable)e);
        }
    }

    public Response addObject(String wikiName, String spaceName, String pageName, Object object) throws XWikiRestException {
        if (object.getClassName() == null) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        try {
            XWikiResource.DocumentInfo documentInfo = this.getDocumentInfo(wikiName, spaceName, pageName, null, null, true, false);
            Document doc = documentInfo.getDocument();
            if (!doc.hasAccessLevel("edit", Utils.getXWikiUser(this.componentManager))) {
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            XWikiDocument xwikiDocument = Utils.getXWiki(this.componentManager).getDocument(doc.getPrefixedFullName(), Utils.getXWikiContext(this.componentManager));
            int objectNumber = xwikiDocument.createNewObject(object.getClassName(), Utils.getXWikiContext(this.componentManager));
            BaseObject xwikiObject = xwikiDocument.getObject(object.getClassName(), objectNumber);
            if (xwikiObject == null) {
                throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
            }
            BaseClass xwikiClass = Utils.getXWiki(this.componentManager).getClass(xwikiObject.getClassName(), Utils.getXWikiContext(this.componentManager));
            String[] arr$ = xwikiClass.getPropertyNames();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String propertyNameObject;
                String propertyName = propertyNameObject = arr$[i$];
                xwikiObject.set(propertyName, (java.lang.Object)"", Utils.getXWikiContext(this.componentManager));
            }
            for (Property property : object.getProperties()) {
                xwikiObject.set(property.getName(), (java.lang.Object)property.getValue(), Utils.getXWikiContext(this.componentManager));
            }
            doc.save();
            return Response.created((URI)UriBuilder.fromUri((URI)this.uriInfo.getBaseUri()).path(ObjectResource.class).build(new java.lang.Object[]{wikiName, spaceName, pageName, object.getClassName(), objectNumber})).entity((java.lang.Object)DomainObjectFactory.createObject(this.objectFactory, this.uriInfo.getBaseUri(), Utils.getXWikiContext(this.componentManager), doc, xwikiObject, false, Utils.getXWikiApi(this.componentManager), false)).build();
        }
        catch (XWikiException e) {
            throw new XWikiRestException((Throwable)e);
        }
    }
}

