/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal.resources.pages;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Document;
import java.net.URI;
import javax.ws.rs.core.Response;
import org.xwiki.rest.XWikiResource;
import org.xwiki.rest.internal.DomainObjectFactory;
import org.xwiki.rest.internal.Utils;
import org.xwiki.rest.model.jaxb.Page;

public class ModifiablePageResource
extends XWikiResource {
    public Response putPage(XWikiResource.DocumentInfo documentInfo, Page page) throws XWikiException {
        Document doc = documentInfo.getDocument();
        boolean save = false;
        if (page.getContent() != null) {
            doc.setContent(page.getContent());
            save = true;
        }
        if (page.getTitle() != null) {
            doc.setTitle(page.getTitle());
            save = true;
        }
        if (page.getParent() != null) {
            doc.setParent(page.getParent());
            save = true;
        }
        if (page.getSyntax() != null && Utils.getXWiki(this.componentManager).getConfiguredSyntaxes().contains(page.getSyntax())) {
            doc.setSyntaxId(page.getSyntax());
            save = true;
        }
        if (save) {
            doc.save();
            page = DomainObjectFactory.createPage(this.objectFactory, this.uriInfo.getBaseUri(), this.uriInfo.getAbsolutePath(), doc, false, Utils.getXWikiApi(this.componentManager), false);
            if (documentInfo.isCreated()) {
                return Response.created((URI)this.uriInfo.getAbsolutePath()).entity((Object)page).build();
            }
            return Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)page).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_MODIFIED).build();
    }

    void deletePage(XWikiResource.DocumentInfo documentInfo) throws XWikiException {
        Document doc = documentInfo.getDocument();
        doc.delete();
    }
}

