/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.api.XWiki;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.user.api.XWikiUser;
import java.lang.reflect.Type;
import java.net.URI;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.context.Execution;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.SpaceReference;
import org.xwiki.model.reference.WikiReference;

public class Utils {
    public static String getPageId(String wikiName, String spaceName, String pageName) {
        XWikiDocument xwikiDocument = new XWikiDocument();
        xwikiDocument.setDatabase(wikiName);
        xwikiDocument.setName(pageName);
        xwikiDocument.setSpace(spaceName);
        Document document = new Document(xwikiDocument, null);
        return document.getPrefixedFullName();
    }

    public static String getSpaceId(String wikiName, String spaceName) {
        EntityReferenceSerializer defaultEntityReferenceSerializer = (EntityReferenceSerializer)com.xpn.xwiki.web.Utils.getComponent((Type)EntityReferenceSerializer.TYPE_STRING);
        SpaceReference spaceReference = new SpaceReference(spaceName, new WikiReference(wikiName));
        return (String)defaultEntityReferenceSerializer.serialize((EntityReference)spaceReference, new Object[0]);
    }

    public static String getPageFullName(String wikiName, String spaceName, String pageName) {
        XWikiDocument xwikiDocument = new XWikiDocument();
        xwikiDocument.setDatabase(wikiName);
        xwikiDocument.setName(pageName);
        xwikiDocument.setSpace(spaceName);
        Document document = new Document(xwikiDocument, null);
        return document.getFullName();
    }

    public static String getObjectId(String wikiName, String spaceName, String pageName, String className, int objectNumber) {
        XWikiDocument xwikiDocument = new XWikiDocument();
        xwikiDocument.setDatabase(wikiName);
        xwikiDocument.setName(pageName);
        xwikiDocument.setSpace(spaceName);
        Document document = new Document(xwikiDocument, null);
        return String.format("%s:%s[%d]", document.getPrefixedFullName(), className, objectNumber);
    }

    public static String getPageId(String wikiName, String pageFullName) {
        XWikiDocument xwikiDocument = new XWikiDocument();
        xwikiDocument.setDatabase(wikiName);
        xwikiDocument.setFullName(pageFullName);
        Document document = new Document(xwikiDocument, null);
        return document.getPrefixedFullName();
    }

    public static Document getParentDocument(Document doc, XWiki xwikiApi) throws XWikiException {
        if (StringUtils.isEmpty((CharSequence)doc.getParent())) {
            return null;
        }
        String parentName = doc.getParent();
        if (!parentName.contains(".")) {
            parentName = doc.getSpace() + "." + parentName;
        }
        return xwikiApi.getDocument(parentName);
    }

    public static XWikiContext getXWikiContext(ComponentManager componentManager) {
        try {
            Execution execution = (Execution)componentManager.getInstance(Execution.class);
            XWikiContext xwikiContext = (XWikiContext)execution.getContext().getProperty("xwikicontext");
            return xwikiContext;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to get XWiki context", e);
        }
    }

    public static com.xpn.xwiki.XWiki getXWiki(ComponentManager componentManager) {
        return Utils.getXWikiContext(componentManager).getWiki();
    }

    public static XWiki getXWikiApi(ComponentManager componentManager) {
        return new XWiki(Utils.getXWiki(componentManager), Utils.getXWikiContext(componentManager));
    }

    public static String getXWikiUser(ComponentManager componentManager) {
        XWikiUser user = Utils.getXWikiContext(componentManager).getXWikiUser();
        if (user == null) {
            return "XWiki.Guest";
        }
        return user.getUser();
    }

    public static String getAuthorName(String author, ComponentManager componentManager) {
        return Utils.getXWikiContext(componentManager).getWiki().getUserName(author, null, false, Utils.getXWikiContext(componentManager));
    }

    public static BaseObject getBaseObject(Document doc, String className, int objectNumber, ComponentManager componentManager) throws XWikiException {
        XWikiDocument xwikiDocument = Utils.getXWiki(componentManager).getDocument(doc.getPrefixedFullName(), Utils.getXWikiContext(componentManager));
        return xwikiDocument.getObject(className, objectNumber);
    }

    public static URI createURI(URI baseURI, Class<?> resourceClass, Object ... pathElements) {
        Object[] encodedPathElements = new String[pathElements.length];
        for (int i = 0; i < pathElements.length; ++i) {
            if (pathElements[i] != null) {
                try {
                    encodedPathElements[i] = URIUtil.encodePath((String)pathElements[i].toString());
                    continue;
                }
                catch (URIException e) {
                    throw new RuntimeException("Failed to encode path element: " + pathElements[i], e);
                }
            }
            encodedPathElements[i] = null;
        }
        return UriBuilder.fromUri((URI)baseURI).path(resourceClass).buildFromEncoded(encodedPathElements);
    }
}

