/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.doc.XWikiDocument;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.localization.LocaleUtils;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.query.QueryManager;
import org.xwiki.rest.XWikiRestComponent;
import org.xwiki.rest.internal.Utils;
import org.xwiki.rest.model.jaxb.ObjectFactory;

@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class XWikiResource
implements XWikiRestComponent,
Initializable {
    @Context
    protected UriInfo uriInfo;
    protected Logger logger;
    protected ObjectFactory objectFactory;
    @Inject
    @Named(value="context")
    protected ComponentManager componentManager;
    @Inject
    protected Provider<XWikiContext> xcontextProvider;
    @Inject
    protected QueryManager queryManager;

    public void initialize() throws InitializationException {
        this.logger = Logger.getLogger(this.getClass().getName());
        this.objectFactory = new ObjectFactory();
        this.logger.log(Level.FINE, String.format("Resource %s initialized. Serving user: '%s'\n", this.getClass().getName(), Utils.getXWikiUser(this.componentManager)));
    }

    public DocumentInfo getDocumentInfo(String wikiName, String spaceName, String pageName, String language, String version, boolean failIfDoesntExist, boolean failIfLocked) throws XWikiException {
        if (wikiName == null || spaceName == null || pageName == null) {
            throw new IllegalArgumentException(String.format("wikiName, spaceName and pageName must all be not null. Current values: (%s:%s.%s)", wikiName, spaceName, pageName));
        }
        String pageFullName = Utils.getPageId(wikiName, spaceName, pageName);
        boolean existed = Utils.getXWikiApi(this.componentManager).exists(pageFullName);
        if (failIfDoesntExist && !existed) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        Document doc = Utils.getXWikiApi(this.componentManager).getDocument(pageFullName);
        if (doc == null) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        if (language != null) {
            Locale locale;
            doc = doc.getTranslatedDocument(language);
            try {
                locale = LocaleUtils.toLocale((String)language);
            }
            catch (Exception e) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            if (!locale.equals(doc.getLocale())) {
                if (failIfDoesntExist) {
                    throw new WebApplicationException(Response.Status.NOT_FOUND);
                }
                XWikiDocument xwikiDocument = new XWikiDocument(new DocumentReference(wikiName, spaceName, pageName), locale);
                doc = new Document(xwikiDocument, this.getXWikiContext());
                existed = false;
            }
        }
        if (version != null) {
            doc = doc.getDocumentRevision(version);
        }
        if (failIfLocked && doc.getLocked()) {
            throw new WebApplicationException(Response.Status.PRECONDITION_FAILED);
        }
        return new DocumentInfo(doc, !existed);
    }

    @GET
    @Produces(value={"uritemplate"})
    public String getUriTemplate() {
        Class<?>[] interfaces;
        if (this.getClass().getAnnotation(Path.class) != null) {
            return this.getClass().getAnnotation(Path.class).value();
        }
        for (Class<?> i : interfaces = this.getClass().getInterfaces()) {
            if (i.getAnnotation(Path.class) == null) continue;
            return i.getAnnotation(Path.class).value();
        }
        return null;
    }

    protected XWikiContext getXWikiContext() {
        return (XWikiContext)this.xcontextProvider.get();
    }

    protected static class DocumentInfo {
        private Document document;
        private boolean created;

        public DocumentInfo(Document document, boolean created) {
            this.document = document;
            this.created = created;
        }

        public Document getDocument() {
            return this.document;
        }

        public boolean isCreated() {
            return this.created;
        }
    }
}

