/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal.resources;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.api.XWiki;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Formatter;
import java.util.List;
import javax.ws.rs.core.UriBuilderException;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.query.QueryException;
import org.xwiki.rest.XWikiResource;
import org.xwiki.rest.internal.Utils;
import org.xwiki.rest.internal.resources.search.SearchSource;
import org.xwiki.rest.model.jaxb.Link;
import org.xwiki.rest.model.jaxb.SearchResult;
import org.xwiki.rest.resources.objects.ObjectResource;
import org.xwiki.rest.resources.pages.PageResource;
import org.xwiki.rest.resources.pages.PageTranslationResource;
import org.xwiki.rest.resources.spaces.SpaceResource;

public class BaseSearchResult
extends XWikiResource {
    protected static final String SEARCH_TEMPLATE_INFO = "q={keywords}(&scope={content|name|title|spaces|objects})*(&number={number})(&start={start})(&orderField={fieldname}(&order={asc|desc}))(&prettyNames={false|true})";
    protected static final String QUERY_TEMPLATE_INFO = "q={query}(&type={xwql,hql,lucene})(&number={number})(&start={start})(&orderField={fieldname}(&order={asc|desc}))(&distinct=1)(&prettyNames={false|true})(&wikis={wikis})(&className={classname})";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<SearchResult> search(List<SearchScope> searchScopes, String keywords, String wikiName, String space, boolean hasProgrammingRights, int number, int start, boolean distinct, String orderField, String order, Boolean withPrettyNames) throws IllegalArgumentException, UriBuilderException, QueryException, XWikiException {
        String database = Utils.getXWikiContext(this.componentManager).getWikiId();
        try {
            Utils.getXWikiContext(this.componentManager).setWikiId(wikiName);
            ArrayList<SearchResult> result = new ArrayList<SearchResult>();
            result.addAll(this.searchPages(searchScopes, keywords, wikiName, space, hasProgrammingRights, number, start, orderField, order, withPrettyNames));
            if (searchScopes.contains((Object)SearchScope.SPACES)) {
                result.addAll(this.searchSpaces(keywords, wikiName, hasProgrammingRights, number, start));
            }
            if (searchScopes.contains((Object)SearchScope.OBJECTS)) {
                result.addAll(this.searchObjects(keywords, wikiName, space, hasProgrammingRights, number, start, orderField, order, withPrettyNames));
            }
            ArrayList<SearchResult> arrayList = result;
            return arrayList;
        }
        finally {
            Utils.getXWikiContext(this.componentManager).setWikiId(database);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<SearchResult> searchPages(List<SearchScope> searchScopes, String keywords, String wikiName, String space, boolean hasProgrammingRights, int number, int start, String orderField, String order, Boolean withPrettyNames) throws QueryException, IllegalArgumentException, UriBuilderException, XWikiException {
        XWiki xwikiApi = Utils.getXWikiApi(this.componentManager);
        String database = Utils.getXWikiContext(this.componentManager).getWikiId();
        try {
            ArrayList<SearchResult> result = new ArrayList<SearchResult>();
            if (keywords == null) {
                ArrayList<SearchResult> arrayList = result;
                return arrayList;
            }
            Formatter f = new Formatter();
            String addColumn = "";
            if (!StringUtils.isBlank((CharSequence)orderField)) {
                String string = addColumn = orderField.equals("") || orderField.equals("fullName") || orderField.equals("name") || orderField.equals("space") ? "" : ", doc." + orderField;
            }
            if (space != null) {
                f.format("select distinct doc.fullName, doc.space, doc.name, doc.language", new Object[0]);
                f.format(addColumn, new Object[0]);
                f.format(" from XWikiDocument as doc where doc.space = :space and ( ", new Object[0]);
            } else {
                f.format("select distinct doc.fullName, doc.space, doc.name, doc.language", new Object[0]);
                f.format(addColumn, new Object[0]);
                f.format(" from XWikiDocument as doc where ( ", new Object[0]);
            }
            int acceptedScopes = 0;
            for (int i = 0; i < searchScopes.size(); ++i) {
                SearchScope scope = searchScopes.get(i);
                switch (scope) {
                    case CONTENT: {
                        f.format("upper(doc.content) like :keywords ", new Object[0]);
                        ++acceptedScopes;
                        break;
                    }
                    case NAME: {
                        f.format("upper(doc.fullName) like :keywords ", new Object[0]);
                        ++acceptedScopes;
                        break;
                    }
                    case TITLE: {
                        f.format("upper(doc.title) like :keywords ", new Object[0]);
                        ++acceptedScopes;
                    }
                }
                if (i == searchScopes.size() - 1) continue;
                f.format(" or ", new Object[0]);
            }
            if (acceptedScopes == 0) {
                ArrayList<SearchResult> i = result;
                return i;
            }
            String orderClause = null;
            orderClause = StringUtils.isBlank((CharSequence)orderField) ? "doc.fullName asc" : ("asc".equals(order) || "desc".equals(order) ? String.format("doc.%s %s", orderField, order) : String.format("doc.%s asc", orderField));
            f.format(") order by %s", orderClause);
            String query = f.toString();
            List queryResult = null;
            queryResult = space != null ? this.queryManager.createQuery(query, "xwql").bindValue("keywords", (Object)String.format("%%%s%%", keywords.toUpperCase())).bindValue("space", (Object)space).addFilter(Utils.getHiddenQueryFilter(this.componentManager)).setOffset(start).setLimit(number).execute() : this.queryManager.createQuery(query, "xwql").bindValue("keywords", (Object)String.format("%%%s%%", keywords.toUpperCase())).addFilter(Utils.getHiddenQueryFilter(this.componentManager)).setOffset(start).setLimit(number).execute();
            for (Object object : queryResult) {
                Object[] fields = (Object[])object;
                String spaceName = (String)fields[1];
                String pageName = (String)fields[2];
                String language = (String)fields[3];
                String pageId = Utils.getPageId(wikiName, spaceName, pageName);
                String pageFullName = Utils.getPageFullName(wikiName, spaceName, pageName);
                if (!xwikiApi.hasAccessLevel("view", pageId)) continue;
                Document doc = xwikiApi.getDocument(pageFullName);
                String title = doc.getDisplayTitle();
                SearchResult searchResult = this.objectFactory.createSearchResult();
                searchResult.setType("page");
                searchResult.setId(pageId);
                searchResult.setPageFullName(pageFullName);
                searchResult.setTitle(title);
                searchResult.setWiki(wikiName);
                searchResult.setSpace(spaceName);
                searchResult.setPageName(pageName);
                searchResult.setVersion(doc.getVersion());
                searchResult.setAuthor(doc.getAuthor());
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(doc.getDate());
                searchResult.setModified(calendar);
                if (withPrettyNames.booleanValue()) {
                    searchResult.setAuthorName(Utils.getAuthorName(doc.getAuthor(), this.componentManager));
                }
                String pageUri = null;
                if (StringUtils.isBlank((CharSequence)language)) {
                    pageUri = Utils.createURI(this.uriInfo.getBaseUri(), PageResource.class, wikiName, spaceName, pageName).toString();
                } else {
                    searchResult.setLanguage(language);
                    pageUri = Utils.createURI(this.uriInfo.getBaseUri(), PageTranslationResource.class, wikiName, spaceName, pageName, language).toString();
                }
                Link pageLink = new Link();
                pageLink.setHref(pageUri);
                pageLink.setRel("http://www.xwiki.org/rel/page");
                searchResult.getLinks().add(pageLink);
                result.add(searchResult);
            }
            ArrayList<SearchResult> arrayList = result;
            return arrayList;
        }
        finally {
            Utils.getXWikiContext(this.componentManager).setWikiId(database);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<SearchResult> searchSpaces(String keywords, String wikiName, boolean hasProgrammingRights, int number, int start) throws QueryException, IllegalArgumentException, UriBuilderException, XWikiException {
        XWiki xwikiApi = Utils.getXWikiApi(this.componentManager);
        String database = Utils.getXWikiContext(this.componentManager).getWikiId();
        try {
            ArrayList<SearchResult> result = new ArrayList<SearchResult>();
            if (keywords == null) {
                ArrayList<SearchResult> arrayList = result;
                return arrayList;
            }
            Formatter f = new Formatter();
            f.format("select distinct doc.space from XWikiDocument as doc where upper(doc.space) like :keywords ", new Object[0]);
            if (hasProgrammingRights) {
                f.format(" order by doc.space asc", new Object[0]);
            } else {
                f.format(" and doc.space<>'XWiki' and doc.space<>'Admin' and doc.space<>'Panels' order by doc.space asc", new Object[0]);
            }
            String query = f.toString();
            List queryResult = null;
            queryResult = this.queryManager.createQuery(query, "xwql").bindValue("keywords", (Object)String.format("%%%s%%", keywords.toUpperCase())).setLimit(number).setOffset(start).execute();
            for (Object object : queryResult) {
                String spaceName = (String)object;
                Document spaceDoc = xwikiApi.getDocument(String.format("%s.WebHome", spaceName));
                if (!xwikiApi.hasAccessLevel("view", spaceDoc.getPrefixedFullName())) continue;
                String title = spaceDoc.getDisplayTitle();
                SearchResult searchResult = this.objectFactory.createSearchResult();
                searchResult.setType("space");
                searchResult.setId(Utils.getSpaceId(wikiName, spaceName));
                searchResult.setWiki(wikiName);
                searchResult.setSpace(spaceName);
                searchResult.setTitle(title);
                Link spaceLink = new Link();
                spaceLink.setRel("http://www.xwiki.org/rel/space");
                String spaceUri = Utils.createURI(this.uriInfo.getBaseUri(), SpaceResource.class, wikiName, spaceName).toString();
                spaceLink.setHref(spaceUri);
                searchResult.getLinks().add(spaceLink);
                String webHomePageId = Utils.getPageId(wikiName, spaceName, "WebHome");
                if (xwikiApi.exists(webHomePageId) && xwikiApi.hasAccessLevel("view", webHomePageId)) {
                    String pageUri = Utils.createURI(this.uriInfo.getBaseUri(), PageResource.class, wikiName, spaceName, "WebHome").toString();
                    Link pageLink = new Link();
                    pageLink.setHref(pageUri);
                    pageLink.setRel("http://www.xwiki.org/rel/home");
                    searchResult.getLinks().add(pageLink);
                }
                result.add(searchResult);
            }
            ArrayList<SearchResult> arrayList = result;
            return arrayList;
        }
        finally {
            Utils.getXWikiContext(this.componentManager).setWikiId(database);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<SearchResult> searchObjects(String keywords, String wikiName, String space, boolean hasProgrammingRights, int number, int start, String orderField, String order, Boolean withPrettyNames) throws QueryException, IllegalArgumentException, UriBuilderException, XWikiException {
        XWikiContext xwikiContext = Utils.getXWikiContext(this.componentManager);
        XWiki xwikiApi = Utils.getXWikiApi(this.componentManager);
        String database = Utils.getXWikiContext(this.componentManager).getWikiId();
        try {
            String addColumn;
            ArrayList<SearchResult> result = new ArrayList<SearchResult>();
            if (keywords == null) {
                ArrayList<SearchResult> arrayList = result;
                return arrayList;
            }
            Formatter f = new Formatter();
            String string = addColumn = orderField.equals("") || orderField.equals("fullName") || orderField.equals("name") || orderField.equals("space") ? "" : ", doc." + orderField;
            if (space != null) {
                f.format("select distinct doc.fullName, doc.space, doc.name, obj.className, obj.number", new Object[0]);
                f.format(addColumn, new Object[0]);
                f.format(" from XWikiDocument as doc, BaseObject as obj, StringProperty as sp, LargeStringProperty as lsp where doc.space = :space and obj.name=doc.fullName and sp.id.id = obj.id and lsp.id.id = obj.id and (upper(sp.value) like :keywords or upper(lsp.value) like :keywords) ", new Object[0]);
            } else {
                f.format("select distinct doc.fullName, doc.space, doc.name, obj.className, obj.number", new Object[0]);
                f.format(addColumn, new Object[0]);
                f.format(" from XWikiDocument as doc, BaseObject as obj, StringProperty as sp, LargeStringProperty as lsp where obj.name=doc.fullName and sp.id.id = obj.id and lsp.id.id = obj.id and (upper(sp.value) like :keywords or upper(lsp.value) like :keywords) ", new Object[0]);
            }
            String orderClause = null;
            orderClause = StringUtils.isBlank((CharSequence)orderField) ? "doc.fullName asc" : ("asc".equals(order) || "desc".equals(order) ? String.format("doc.%s %s", orderField, order) : String.format("doc.%s asc", orderField));
            if (hasProgrammingRights) {
                f.format(" order by %s", orderClause);
            } else {
                f.format(" and doc.space<>'XWiki' and doc.space<>'Admin' and doc.space<>'Panels' and doc.name<>'WebPreferences' order by %s", orderClause);
            }
            String query = f.toString();
            List queryResult = null;
            queryResult = space != null ? this.queryManager.createQuery(query, "xwql").bindValue("keywords", (Object)String.format("%%%s%%", keywords.toUpperCase())).bindValue("space", (Object)space).setLimit(number).execute() : this.queryManager.createQuery(query, "xwql").bindValue("keywords", (Object)String.format("%%%s%%", keywords.toUpperCase())).setLimit(number).execute();
            for (Object object : queryResult) {
                Object[] fields = (Object[])object;
                String spaceName = (String)fields[1];
                String pageName = (String)fields[2];
                String className = (String)fields[3];
                int objectNumber = (Integer)fields[4];
                String id = Utils.getObjectId(wikiName, spaceName, pageName, className, objectNumber);
                String pageId = Utils.getPageId(wikiName, spaceName, pageName);
                String pageFullName = Utils.getPageFullName(wikiName, spaceName, pageName);
                if (!xwikiApi.hasAccessLevel("view", pageId) || xwikiContext.getUserReference() == null) continue;
                Document doc = xwikiApi.getDocument(pageFullName);
                String title = doc.getDisplayTitle();
                SearchResult searchResult = this.objectFactory.createSearchResult();
                searchResult.setType("object");
                searchResult.setId(id);
                searchResult.setPageFullName(pageFullName);
                searchResult.setTitle(title);
                searchResult.setWiki(wikiName);
                searchResult.setSpace(spaceName);
                searchResult.setPageName(pageName);
                searchResult.setVersion(doc.getVersion());
                searchResult.setClassName(className);
                searchResult.setObjectNumber(Integer.valueOf(objectNumber));
                searchResult.setAuthor(doc.getAuthor());
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(doc.getDate());
                searchResult.setModified(calendar);
                if (withPrettyNames.booleanValue()) {
                    searchResult.setAuthorName(Utils.getAuthorName(doc.getAuthor(), this.componentManager));
                }
                String pageUri = Utils.createURI(this.uriInfo.getBaseUri(), PageResource.class, wikiName, spaceName, pageName).toString();
                Link pageLink = new Link();
                pageLink.setHref(pageUri);
                pageLink.setRel("http://www.xwiki.org/rel/page");
                searchResult.getLinks().add(pageLink);
                String objectUri = Utils.createURI(this.uriInfo.getBaseUri(), ObjectResource.class, wikiName, spaceName, pageName, className, objectNumber).toString();
                Link objectLink = new Link();
                objectLink.setHref(objectUri);
                objectLink.setRel("http://www.xwiki.org/rel/object");
                searchResult.getLinks().add(objectLink);
                result.add(searchResult);
            }
            ArrayList<SearchResult> arrayList = result;
            return arrayList;
        }
        finally {
            Utils.getXWikiContext(this.componentManager).setWikiId(database);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<SearchResult> searchQuery(String query, String queryTypeString, String wikiName, String wikis, boolean hasProgrammingRights, String orderField, String order, boolean distinct, int number, int start, Boolean withPrettyNames, String className) throws Exception {
        String currentWiki = Utils.getXWikiContext(this.componentManager).getWikiId();
        try {
            List<SearchResult> result;
            Utils.getXWikiContext(this.componentManager).setWikiId(wikiName);
            if (queryTypeString != null) {
                SearchSource searchSource = (SearchSource)this.componentManager.getInstance(SearchSource.class, queryTypeString.toLowerCase());
                result = searchSource.search(query, wikiName, wikis, hasProgrammingRights, orderField, order, distinct, number, start, withPrettyNames, className, this.uriInfo);
            } else {
                result = new ArrayList<SearchResult>();
            }
            ArrayList<SearchResult> arrayList = result;
            return arrayList;
        }
        finally {
            Utils.getXWikiContext(this.componentManager).setWikiId(currentWiki);
        }
    }

    protected List<SearchScope> parseSearchScopeStrings(List<String> searchScopeStrings) {
        ArrayList<SearchScope> searchScopes = new ArrayList<SearchScope>();
        for (String searchScopeString : searchScopeStrings) {
            if (searchScopeString == null || searchScopes.contains(searchScopeString)) continue;
            try {
                SearchScope searchScope = SearchScope.valueOf(searchScopeString.toUpperCase());
                searchScopes.add(searchScope);
            }
            catch (IllegalArgumentException e) {}
        }
        if (searchScopes.isEmpty()) {
            searchScopes.add(SearchScope.CONTENT);
        }
        return searchScopes;
    }

    protected static enum SearchScope {
        SPACES,
        NAME,
        CONTENT,
        TITLE,
        OBJECTS;

    }
}

