/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal.resources;

import com.xpn.xwiki.doc.rcs.XWikiRCSNodeId;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import org.xwiki.component.annotation.Component;
import org.xwiki.query.QueryException;
import org.xwiki.rest.XWikiResource;
import org.xwiki.rest.XWikiRestException;
import org.xwiki.rest.internal.DomainObjectFactory;
import org.xwiki.rest.internal.Utils;
import org.xwiki.rest.model.jaxb.History;
import org.xwiki.rest.model.jaxb.HistorySummary;
import org.xwiki.rest.resources.ModificationsResource;

@Component(value="org.xwiki.rest.internal.resources.ModificationsResourceImpl")
public class ModificationsResourceImpl
extends XWikiResource
implements ModificationsResource {
    public History getModifications(String wikiName, Integer start, Integer number, String order, Long ts, Boolean withPrettyNames) throws XWikiRestException {
        String database = Utils.getXWikiContext(this.componentManager).getWikiId();
        try {
            History history = new History();
            Utils.getXWikiContext(this.componentManager).setWikiId(wikiName);
            String query = String.format("select doc.space, doc.name, doc.language, rcs.id, rcs.date, rcs.author, rcs.comment from XWikiRCSNodeInfo as rcs, XWikiDocument as doc where rcs.id.docId = doc.id and rcs.date > :date order by rcs.date %s, rcs.id.version1 %s, rcs.id.version2 %s", order, order, order);
            List queryResult = null;
            queryResult = this.queryManager.createQuery(query, "xwql").bindValue("date", (Object)new Date(ts)).setLimit(number.intValue()).setOffset(start.intValue()).execute();
            for (Object object : queryResult) {
                Object[] fields = (Object[])object;
                String spaceName = (String)fields[0];
                String pageName = (String)fields[1];
                String language = (String)fields[2];
                if (language.equals("")) {
                    language = null;
                }
                XWikiRCSNodeId nodeId = (XWikiRCSNodeId)fields[3];
                Timestamp timestamp = (Timestamp)fields[4];
                Date modified = new Date(timestamp.getTime());
                String modifier = (String)fields[5];
                String comment = (String)fields[6];
                HistorySummary historySummary = DomainObjectFactory.createHistorySummary(this.objectFactory, this.uriInfo.getBaseUri(), wikiName, spaceName, pageName, language, nodeId.getVersion(), modifier, modified, comment, Utils.getXWikiApi(this.componentManager), withPrettyNames);
                history.getHistorySummaries().add(historySummary);
            }
            History history2 = history;
            return history2;
        }
        catch (QueryException e) {
            throw new XWikiRestException((Throwable)e);
        }
        finally {
            Utils.getXWikiContext(this.componentManager).setWikiId(database);
        }
    }
}

