/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal.resources.pages;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.BaseProperty;
import com.xpn.xwiki.objects.classes.BaseClass;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.xwiki.component.annotation.Component;
import org.xwiki.rest.XWikiResource;
import org.xwiki.rest.XWikiRestException;
import org.xwiki.rest.internal.Utils;
import org.xwiki.rest.internal.resources.pages.ModifiablePageResource;
import org.xwiki.rest.model.jaxb.Link;
import org.xwiki.rest.model.jaxb.Tag;
import org.xwiki.rest.model.jaxb.Tags;
import org.xwiki.rest.resources.pages.PageTagsResource;
import org.xwiki.rest.resources.tags.PagesForTagsResource;

@Component(value="org.xwiki.rest.internal.resources.pages.PageTagsResourceImpl")
public class PageTagsResourceImpl
extends ModifiablePageResource
implements PageTagsResource {
    public Tags getPageTags(String wikiName, String spaceName, String pageName) throws XWikiRestException {
        try {
            String pageId = Utils.getPageId(wikiName, spaceName, pageName);
            List<String> tagNames = this.getTagsFromDocument(pageId);
            Tags tags = this.objectFactory.createTags();
            for (String tagName : tagNames) {
                Tag tag = this.objectFactory.createTag();
                tag.setName(tagName);
                String tagUri = Utils.createURI(this.uriInfo.getBaseUri(), PagesForTagsResource.class, wikiName, tagName).toString();
                Link tagLink = this.objectFactory.createLink();
                tagLink.setHref(tagUri);
                tagLink.setRel("http://www.xwiki.org/rel/tag");
                tag.getLinks().add(tagLink);
                tags.getTags().add(tag);
            }
            return tags;
        }
        catch (XWikiException e) {
            throw new XWikiRestException((Throwable)e);
        }
    }

    public Response setTags(String wikiName, String spaceName, String pageName, Tags tags) throws XWikiRestException {
        try {
            XWikiResource.DocumentInfo documentInfo = this.getDocumentInfo(wikiName, spaceName, pageName, null, null, true, false);
            Document doc = documentInfo.getDocument();
            if (!doc.hasAccessLevel("edit", Utils.getXWikiUser(this.componentManager))) {
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            ArrayList<String> tagNames = new ArrayList<String>();
            for (Tag tag : tags.getTags()) {
                tagNames.add(tag.getName());
            }
            XWikiDocument xwikiDocument = Utils.getXWiki(this.componentManager).getDocument(doc.getDocumentReference(), Utils.getXWikiContext(this.componentManager));
            BaseObject xwikiObject = xwikiDocument.getObject("XWiki.TagClass", 0);
            if (xwikiObject == null) {
                int objectNumber = xwikiDocument.createNewObject("XWiki.TagClass", Utils.getXWikiContext(this.componentManager));
                xwikiObject = xwikiDocument.getObject("XWiki.TagClass", objectNumber);
                if (xwikiObject == null) {
                    throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
                }
                BaseClass xwikiClass = Utils.getXWiki(this.componentManager).getClass(xwikiObject.getClassName(), Utils.getXWikiContext(this.componentManager));
                String[] arr$ = xwikiClass.getPropertyNames();
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    String propertyNameObject;
                    String propertyName = propertyNameObject = arr$[i$];
                    xwikiObject.set(propertyName, (Object)"", Utils.getXWikiContext(this.componentManager));
                }
            }
            xwikiObject.set("tags", tagNames, Utils.getXWikiContext(this.componentManager));
            doc.save();
            return Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)tags).build();
        }
        catch (XWikiException e) {
            throw new XWikiRestException((Throwable)e);
        }
    }

    private List<String> getTagsFromDocument(String documentId) throws XWikiException {
        BaseProperty prop;
        XWikiDocument document = Utils.getXWiki(this.componentManager).getDocument(documentId, Utils.getXWikiContext(this.componentManager));
        BaseObject object = document.getObject("XWiki.TagClass");
        if (object != null && (prop = (BaseProperty)object.safeget("tags")) != null) {
            return (List)prop.getValue();
        }
        return new ArrayList<String>();
    }
}

