/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal.resources.search;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.api.XWiki;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Formatter;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.query.QueryManager;
import org.xwiki.rest.internal.DomainObjectFactory;
import org.xwiki.rest.internal.Utils;
import org.xwiki.rest.internal.resources.search.AbstractSearchSource;
import org.xwiki.rest.model.jaxb.Link;
import org.xwiki.rest.model.jaxb.SearchResult;
import org.xwiki.rest.resources.pages.PageResource;
import org.xwiki.rest.resources.pages.PageTranslationResource;

public abstract class AbstractDatabaseSearchSource
extends AbstractSearchSource {
    @Inject
    protected Provider<XWikiContext> xcontextProvider;
    @Inject
    protected QueryManager queryManager;
    protected final String queryLanguage;

    public AbstractDatabaseSearchSource(String queryLanguage) {
        this.queryLanguage = queryLanguage;
    }

    @Override
    public List<SearchResult> search(String query, String wikiName, String wikis, boolean hasProgrammingRights, String orderField, String order, boolean distinct, int number, int start, Boolean withPrettyNames, String className, UriInfo uriInfo) throws Exception {
        XWikiContext xwikiContext = (XWikiContext)this.xcontextProvider.get();
        XWiki xwikiApi = new XWiki(xwikiContext.getWiki(), xwikiContext);
        ArrayList<SearchResult> result = new ArrayList<SearchResult>();
        if (query == null || query.trim().startsWith("select")) {
            return result;
        }
        Formatter f = new Formatter();
        if (distinct) {
            f.format("select distinct doc.fullName, doc.space, doc.name, doc.language from XWikiDocument as doc %s", query);
        } else {
            f.format("select doc.fullName, doc.space, doc.name, doc.language from XWikiDocument as doc %s", query);
        }
        String squery = f.toString();
        if (!hasProgrammingRights) {
            squery.replace("where ", "where doc.space<>'XWiki' and doc.space<>'Admin' and doc.space<>'Panels' and doc.name<>'WebPreferences' and ");
        }
        List queryResult = null;
        queryResult = this.queryManager.createQuery(squery, this.queryLanguage).setLimit(number).setOffset(start).execute();
        for (Object object : queryResult) {
            XWikiDocument xdocument;
            BaseObject baseObject;
            Object[] fields = (Object[])object;
            String spaceName = (String)fields[1];
            String pageName = (String)fields[2];
            String language = (String)fields[3];
            String pageId = Utils.getPageId(wikiName, spaceName, pageName);
            String pageFullName = Utils.getPageFullName(wikiName, spaceName, pageName);
            if (!xwikiApi.hasAccessLevel("view", pageId)) continue;
            Document doc = xwikiApi.getDocument(pageFullName);
            String title = doc.getDisplayTitle();
            SearchResult searchResult = this.objectFactory.createSearchResult();
            searchResult.setType("page");
            searchResult.setId(pageId);
            searchResult.setPageFullName(pageFullName);
            searchResult.setTitle(title);
            searchResult.setWiki(wikiName);
            searchResult.setSpace(spaceName);
            searchResult.setPageName(pageName);
            searchResult.setVersion(doc.getVersion());
            searchResult.setAuthor(doc.getAuthor());
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(doc.getDate());
            searchResult.setModified(calendar);
            if (withPrettyNames.booleanValue()) {
                searchResult.setAuthorName(xwikiApi.getUserName(doc.getAuthor(), false));
            }
            if (className != null && !className.equals("") && xwikiContext.getUserReference() != null && (baseObject = (xdocument = xwikiContext.getWiki().getDocument(doc.getDocumentReference(), xwikiContext)).getObject(className)) != null) {
                searchResult.setObject(DomainObjectFactory.createObject(this.objectFactory, uriInfo.getBaseUri(), xwikiContext, doc, baseObject, false, xwikiApi, false));
            }
            String pageUri = null;
            if (StringUtils.isBlank((CharSequence)language)) {
                pageUri = Utils.createURI(uriInfo.getBaseUri(), PageResource.class, wikiName, spaceName, pageName).toString();
            } else {
                searchResult.setLanguage(language);
                pageUri = Utils.createURI(uriInfo.getBaseUri(), PageTranslationResource.class, wikiName, spaceName, pageName, language).toString();
            }
            Link pageLink = new Link();
            pageLink.setHref(pageUri);
            pageLink.setRel("http://www.xwiki.org/rel/page");
            searchResult.getLinks().add(pageLink);
            result.add(searchResult);
        }
        return result;
    }
}

