/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal;

import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.ext.servlet.ServletUtils;
import org.restlet.routing.Filter;
import org.xwiki.component.manager.ComponentLifecycleException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.rest.XWikiRestComponent;

public class XWikiSetupCleanupFilter
extends Filter {
    protected int beforeHandle(Request request, Response response) {
        this.getContext().getAttributes().put("httpRequest", XWikiSetupCleanupFilter.getHttpRequest(request));
        return 0;
    }

    protected void afterHandle(Request request, Response response) {
        ComponentManager componentManager = (ComponentManager)this.getApplication().getContext().getAttributes().get("xwikiComponentManager");
        for (XWikiRestComponent component : this.getReleasableComponents(componentManager)) {
            try {
                componentManager.release((Object)component);
            }
            catch (ComponentLifecycleException e) {
                this.getLogger().log(Level.WARNING, "Unable to release component [{0}]. ({1})", new Object[]{component.getClass().getName(), e.getMessage()});
            }
        }
        if (response.getEntity() != null && !response.getEntity().isAvailable()) {
            response.setEntity(null);
        }
    }

    private List<XWikiRestComponent> getReleasableComponents(ComponentManager componentManager) {
        try {
            ExecutionContext executionContext = ((Execution)componentManager.getInstance(Execution.class)).getContext();
            List<XWikiRestComponent> releasableComponents = (List<XWikiRestComponent>)executionContext.getProperty("rest.releasableComponentReferences");
            return releasableComponents != null ? releasableComponents : Collections.emptyList();
        }
        catch (Exception e) {
            this.getLogger().log(Level.WARNING, "Failed to retrieve the list of releasable components.", e);
            return Collections.emptyList();
        }
    }

    protected static HttpServletRequest getHttpRequest(Request req) {
        return ServletUtils.getRequest((Request)req);
    }
}

