/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import javax.inject.Inject;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.xwiki.job.Job;
import org.xwiki.job.JobExecutor;
import org.xwiki.job.JobStatusStore;
import org.xwiki.job.event.status.JobStatus;
import org.xwiki.rest.XWikiResource;

public class XWikiJobResource
extends XWikiResource {
    @Inject
    protected JobExecutor jobExecutor;
    @Inject
    protected JobStatusStore jobStore;

    protected JobStatus getRealJobStatus(String jobId) throws WebApplicationException {
        String[] idArray = jobId.split("/");
        ArrayList<String> id = new ArrayList<String>(idArray.length);
        for (String idElement : idArray) {
            try {
                id.add(URLDecoder.decode(idElement, "UTF8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new WebApplicationException((Throwable)e);
            }
        }
        Job job = this.jobExecutor.getJob(id);
        JobStatus jobStatus = job == null ? this.jobStore.getJobStatus(id) : job.getStatus();
        if (jobStatus == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        return jobStatus;
    }
}

