/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rest.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Attachment;
import com.xpn.xwiki.api.Class;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.api.Element;
import com.xpn.xwiki.api.Object;
import com.xpn.xwiki.api.Property;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.BaseObjectReference;
import com.xpn.xwiki.objects.BaseProperty;
import com.xpn.xwiki.objects.PropertyInterface;
import com.xpn.xwiki.objects.classes.BaseClass;
import com.xpn.xwiki.objects.classes.ListClass;
import com.xpn.xwiki.objects.classes.PropertyClass;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Formatter;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.rest.internal.Utils;
import org.xwiki.rest.model.jaxb.Attribute;
import org.xwiki.rest.model.jaxb.Link;
import org.xwiki.rest.model.jaxb.ObjectFactory;
import org.xwiki.rest.model.jaxb.ObjectSummary;
import org.xwiki.rest.model.jaxb.Page;
import org.xwiki.rest.model.jaxb.PageSummary;
import org.xwiki.rest.model.jaxb.Space;
import org.xwiki.rest.model.jaxb.Translation;
import org.xwiki.rest.model.jaxb.Translations;
import org.xwiki.rest.model.jaxb.Wiki;
import org.xwiki.rest.resources.ModificationsResource;
import org.xwiki.rest.resources.SyntaxesResource;
import org.xwiki.rest.resources.attachments.AttachmentResource;
import org.xwiki.rest.resources.attachments.AttachmentVersionResource;
import org.xwiki.rest.resources.attachments.AttachmentsAtPageVersionResource;
import org.xwiki.rest.resources.attachments.AttachmentsResource;
import org.xwiki.rest.resources.classes.ClassPropertiesResource;
import org.xwiki.rest.resources.classes.ClassPropertyResource;
import org.xwiki.rest.resources.classes.ClassResource;
import org.xwiki.rest.resources.classes.ClassesResource;
import org.xwiki.rest.resources.comments.CommentsResource;
import org.xwiki.rest.resources.comments.CommentsVersionResource;
import org.xwiki.rest.resources.objects.AllObjectsForClassNameResource;
import org.xwiki.rest.resources.objects.ObjectAtPageVersionResource;
import org.xwiki.rest.resources.objects.ObjectPropertiesAtPageVersionResource;
import org.xwiki.rest.resources.objects.ObjectPropertiesResource;
import org.xwiki.rest.resources.objects.ObjectPropertyAtPageVersionResource;
import org.xwiki.rest.resources.objects.ObjectPropertyResource;
import org.xwiki.rest.resources.objects.ObjectResource;
import org.xwiki.rest.resources.objects.ObjectsAtPageVersionResource;
import org.xwiki.rest.resources.objects.ObjectsResource;
import org.xwiki.rest.resources.pages.PageChildrenResource;
import org.xwiki.rest.resources.pages.PageHistoryResource;
import org.xwiki.rest.resources.pages.PageResource;
import org.xwiki.rest.resources.pages.PageTagsResource;
import org.xwiki.rest.resources.pages.PageTranslationHistoryResource;
import org.xwiki.rest.resources.pages.PageTranslationResource;
import org.xwiki.rest.resources.pages.PagesResource;
import org.xwiki.rest.resources.spaces.SpaceResource;
import org.xwiki.rest.resources.spaces.SpaceSearchResource;
import org.xwiki.rest.resources.spaces.SpacesResource;
import org.xwiki.rest.resources.wikis.WikiSearchQueryResource;
import org.xwiki.rest.resources.wikis.WikiSearchResource;

@Component(roles={ModelFactory.class})
@Singleton
public class ModelFactory {
    private final ObjectFactory objectFactory = new ObjectFactory();
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private EntityReferenceSerializer<String> serializer;

    public boolean toDocument(Document doc, Page restPage) throws XWikiException {
        boolean modified = false;
        if (restPage.getContent() != null) {
            doc.setContent(restPage.getContent());
            modified = true;
        }
        if (restPage.getTitle() != null) {
            doc.setTitle(restPage.getTitle());
            modified = true;
        }
        if (restPage.getParent() != null) {
            doc.setParent(restPage.getParent());
            modified = true;
        }
        if (restPage.getSyntax() != null) {
            doc.setSyntaxId(restPage.getSyntax());
            modified = true;
        }
        doc.setHidden(restPage.isHidden());
        if (restPage.getObjects() != null) {
            HashSet<BaseObjectReference> newReferences = new HashSet<BaseObjectReference>();
            for (ObjectSummary restObjectSummary : restPage.getObjects().getObjectSummaries()) {
                if (restObjectSummary == null) continue;
                org.xwiki.rest.model.jaxb.Object restObject = (org.xwiki.rest.model.jaxb.Object)restObjectSummary;
                Object xwikiObject = doc.getObject(restObject.getClassName(), restObject.getNumber());
                if (xwikiObject == null) {
                    xwikiObject = doc.newObject(restObject.getClassName());
                }
                this.toObject(xwikiObject, restObject);
                modified = true;
                newReferences.add(xwikiObject.getReference());
            }
            ArrayList<Object> toRemove = new ArrayList<Object>();
            for (Vector objects : doc.getxWikiObjects().values()) {
                for (Object object : objects) {
                    if (newReferences.contains(object.getReference())) continue;
                    toRemove.add(object);
                }
            }
            for (Object obj : toRemove) {
                doc.removeObject(obj);
                modified = true;
            }
        }
        return modified;
    }

    private void fillObjectSummary(ObjectSummary objectSummary, Document doc, BaseObject xwikiObject, Boolean withPrettyNames) {
        objectSummary.setId(String.format("%s:%s", doc.getPrefixedFullName(), xwikiObject.getGuid()));
        objectSummary.setGuid(xwikiObject.getGuid());
        objectSummary.setPageId(doc.getPrefixedFullName());
        objectSummary.setPageVersion(doc.getVersion());
        objectSummary.setPageAuthor(doc.getAuthor());
        if (withPrettyNames.booleanValue()) {
            XWikiContext xwikiContext = (XWikiContext)this.xcontextProvider.get();
            objectSummary.setPageAuthorName(xwikiContext.getWiki().getUserName(doc.getAuthor(), null, false, xwikiContext));
        }
        objectSummary.setWiki(doc.getWiki());
        objectSummary.setSpace(doc.getSpace());
        objectSummary.setPageName(doc.getName());
        objectSummary.setClassName(xwikiObject.getClassName());
        objectSummary.setNumber(xwikiObject.getNumber());
        String[] propertyNames = xwikiObject.getPropertyNames();
        if (propertyNames.length > 0) {
            try {
                objectSummary.setHeadline(ModelFactory.serializePropertyValue(xwikiObject.get(propertyNames[0])));
            }
            catch (XWikiException xWikiException) {
                // empty catch block
            }
        }
    }

    public ObjectSummary toRestObjectSummary(URI baseUri, Document doc, BaseObject xwikiObject, boolean useVersion, Boolean withPrettyNames) {
        ObjectSummary objectSummary = this.objectFactory.createObjectSummary();
        this.fillObjectSummary(objectSummary, doc, xwikiObject, withPrettyNames);
        Link objectLink = ModelFactory.getObjectLink(this.objectFactory, baseUri, doc, xwikiObject, useVersion, "http://www.xwiki.org/rel/object");
        objectSummary.getLinks().add(objectLink);
        String propertiesUri = useVersion ? Utils.createURI(baseUri, ObjectPropertiesAtPageVersionResource.class, doc.getWiki(), Utils.getSpacesFromSpaceId(doc.getSpace()), doc.getName(), doc.getVersion(), xwikiObject.getClassName(), xwikiObject.getNumber()).toString() : Utils.createURI(baseUri, ObjectPropertiesResource.class, doc.getWiki(), Utils.getSpacesFromSpaceId(doc.getSpace()), doc.getName(), xwikiObject.getClassName(), xwikiObject.getNumber()).toString();
        Link propertyLink = this.objectFactory.createLink();
        propertyLink.setHref(propertiesUri);
        propertyLink.setRel("http://www.xwiki.org/rel/properties");
        objectSummary.getLinks().add(propertyLink);
        return objectSummary;
    }

    public void toObject(Object xwikiObject, org.xwiki.rest.model.jaxb.Object restObject) {
        for (org.xwiki.rest.model.jaxb.Property restProperty : restObject.getProperties()) {
            xwikiObject.set(restProperty.getName(), (java.lang.Object)restProperty.getValue());
        }
    }

    public org.xwiki.rest.model.jaxb.Object toRestObject(URI baseUri, Document doc, BaseObject xwikiObject, boolean useVersion, Boolean withPrettyNames) {
        org.xwiki.rest.model.jaxb.Object object = this.objectFactory.createObject();
        this.fillObjectSummary((ObjectSummary)object, doc, xwikiObject, withPrettyNames);
        XWikiContext xwikiContext = (XWikiContext)this.xcontextProvider.get();
        BaseClass xwikiClass = xwikiObject.getXClass(xwikiContext);
        for (java.lang.Object propertyClassObject : xwikiClass.getProperties()) {
            ListClass listClass22;
            List allowedValueList;
            PropertyClass propertyClass = (PropertyClass)propertyClassObject;
            org.xwiki.rest.model.jaxb.Property property = this.objectFactory.createProperty();
            for (java.lang.Object o : propertyClass.getProperties()) {
                BaseProperty baseProperty = (BaseProperty)o;
                Attribute attribute = this.objectFactory.createAttribute();
                attribute.setName(baseProperty.getName());
                if (baseProperty.getValue() != null) {
                    attribute.setValue(baseProperty.getValue().toString());
                } else {
                    attribute.setValue("");
                }
                property.getAttributes().add(attribute);
            }
            if (propertyClass instanceof ListClass && !(allowedValueList = (listClass22 = (ListClass)propertyClass).getList(xwikiContext)).isEmpty()) {
                Formatter f = new Formatter();
                for (int i = 0; i < allowedValueList.size(); ++i) {
                    if (i != allowedValueList.size() - 1) {
                        f.format("%s,", allowedValueList.get(i).toString());
                        continue;
                    }
                    f.format("%s", allowedValueList.get(i).toString());
                }
                Attribute attribute = this.objectFactory.createAttribute();
                attribute.setName("allowedValues");
                attribute.setValue(f.toString());
                property.getAttributes().add(attribute);
            }
            property.setName(propertyClass.getName());
            property.setType(propertyClass.getClassType());
            try {
                property.setValue(ModelFactory.serializePropertyValue(xwikiObject.get(propertyClass.getName())));
            }
            catch (XWikiException listClass22) {
                // empty catch block
            }
            String propertyUri = useVersion ? Utils.createURI(baseUri, ObjectPropertyAtPageVersionResource.class, doc.getWiki(), Utils.getSpacesFromSpaceId(doc.getSpace()), doc.getName(), doc.getVersion(), xwikiObject.getClassName(), xwikiObject.getNumber(), propertyClass.getName()).toString() : Utils.createURI(baseUri, ObjectPropertyResource.class, doc.getWiki(), Utils.getSpacesFromSpaceId(doc.getSpace()), doc.getName(), xwikiObject.getClassName(), xwikiObject.getNumber(), propertyClass.getName()).toString();
            Link propertyLink = this.objectFactory.createLink();
            propertyLink.setHref(propertyUri);
            propertyLink.setRel("self");
            property.getLinks().add(propertyLink);
            object.getProperties().add(property);
        }
        Link objectLink = ModelFactory.getObjectLink(this.objectFactory, baseUri, doc, xwikiObject, useVersion, "self");
        object.getLinks().add(objectLink);
        return object;
    }

    private static Link getObjectLink(ObjectFactory objectFactory, URI baseUri, Document doc, BaseObject xwikiObject, boolean useVersion, String relation) {
        String objectUri = useVersion ? Utils.createURI(baseUri, ObjectAtPageVersionResource.class, doc.getWiki(), Utils.getSpacesFromSpaceId(doc.getSpace()), doc.getName(), doc.getVersion(), xwikiObject.getClassName(), xwikiObject.getNumber()).toString() : Utils.createURI(baseUri, ObjectResource.class, doc.getWiki(), Utils.getSpacesFromSpaceId(doc.getSpace()), doc.getName(), xwikiObject.getClassName(), xwikiObject.getNumber()).toString();
        Link objectLink = objectFactory.createLink();
        objectLink.setHref(objectUri);
        objectLink.setRel(relation);
        return objectLink;
    }

    public Wiki toRestWiki(URI baseUri, String wikiName) {
        Wiki wiki = this.objectFactory.createWiki().withId(wikiName).withName(wikiName);
        String spacesUri = Utils.createURI(baseUri, SpacesResource.class, wikiName).toString();
        Link spacesLink = this.objectFactory.createLink();
        spacesLink.setHref(spacesUri);
        spacesLink.setRel("http://www.xwiki.org/rel/spaces");
        wiki.getLinks().add(spacesLink);
        String classesUri = Utils.createURI(baseUri, ClassesResource.class, wikiName).toString();
        Link classesLink = this.objectFactory.createLink();
        classesLink.setHref(classesUri);
        classesLink.setRel("http://www.xwiki.org/rel/classes");
        wiki.getLinks().add(classesLink);
        String modificationsUri = Utils.createURI(baseUri, ModificationsResource.class, wikiName).toString();
        Link modificationsLink = this.objectFactory.createLink();
        modificationsLink.setHref(modificationsUri);
        modificationsLink.setRel("http://www.xwiki.org/rel/modifications");
        wiki.getLinks().add(modificationsLink);
        String searchUri = Utils.createURI(baseUri, WikiSearchResource.class, wikiName).toString();
        Link searchLink = this.objectFactory.createLink();
        searchLink.setHref(searchUri);
        searchLink.setRel("http://www.xwiki.org/rel/search");
        wiki.getLinks().add(searchLink);
        String queryUri = Utils.createURI(baseUri, WikiSearchQueryResource.class, wikiName).toString();
        Link queryLink = this.objectFactory.createLink();
        queryLink.setHref(queryUri);
        queryLink.setRel("http://www.xwiki.org/rel/query");
        wiki.getLinks().add(queryLink);
        return wiki;
    }

    public Space toRestSpace(URI baseUri, String wikiName, List<String> spaces, Document home) {
        Space space = this.objectFactory.createSpace();
        space.setId(Utils.getSpaceId(wikiName, spaces));
        space.setWiki(wikiName);
        space.setName(spaces.get(spaces.size() - 1));
        if (home != null) {
            space.setHome(home.getPrefixedFullName());
            space.setXwikiRelativeUrl(home.getURL("view"));
            space.setXwikiAbsoluteUrl(home.getExternalURL("view"));
        }
        String pagesUri = Utils.createURI(baseUri, PagesResource.class, wikiName, spaces).toString();
        Link pagesLink = this.objectFactory.createLink();
        pagesLink.setHref(pagesUri);
        pagesLink.setRel("http://www.xwiki.org/rel/pages");
        space.getLinks().add(pagesLink);
        if (home != null) {
            String homeUri = Utils.createURI(baseUri, PageResource.class, wikiName, spaces, home.getName()).toString();
            Link homeLink = this.objectFactory.createLink();
            homeLink.setHref(homeUri);
            homeLink.setRel("http://www.xwiki.org/rel/home");
            space.getLinks().add(homeLink);
        }
        String searchUri = Utils.createURI(baseUri, SpaceSearchResource.class, wikiName, spaces).toString();
        Link searchLink = this.objectFactory.createLink();
        searchLink.setHref(searchUri);
        searchLink.setRel("http://www.xwiki.org/rel/search");
        space.getLinks().add(searchLink);
        return space;
    }

    public Translations toRestTranslations(URI baseUri, Document doc) throws XWikiException {
        Translations translations = this.objectFactory.createTranslations();
        List languages = doc.getTranslationList();
        List<String> spaces = Utils.getSpacesFromSpaceId(doc.getSpace());
        if (!languages.isEmpty() && !doc.getDefaultLanguage().equals("")) {
            translations.setDefault(doc.getDefaultLanguage());
            Translation translation = this.objectFactory.createTranslation();
            translation.setLanguage(doc.getDefaultLanguage());
            String pageTranslationUri = Utils.createURI(baseUri, PageResource.class, doc.getWiki(), spaces, doc.getName()).toString();
            Link pageTranslationLink = this.objectFactory.createLink();
            pageTranslationLink.setHref(pageTranslationUri);
            pageTranslationLink.setRel("http://www.xwiki.org/rel/page");
            translation.getLinks().add(pageTranslationLink);
            String historyUri = Utils.createURI(baseUri, PageHistoryResource.class, doc.getWiki(), spaces, doc.getName()).toString();
            Link historyLink = this.objectFactory.createLink();
            historyLink.setHref(historyUri);
            historyLink.setRel("http://www.xwiki.org/rel/history");
            translation.getLinks().add(historyLink);
            translations.getTranslations().add(translation);
        }
        for (String language : languages) {
            Translation translation = this.objectFactory.createTranslation();
            translation.setLanguage(language);
            String pageTranslationUri = Utils.createURI(baseUri, PageTranslationResource.class, doc.getWiki(), spaces, doc.getName(), language).toString();
            Link pageTranslationLink = this.objectFactory.createLink();
            pageTranslationLink.setHref(pageTranslationUri);
            pageTranslationLink.setRel("http://www.xwiki.org/rel/page");
            translation.getLinks().add(pageTranslationLink);
            String historyUri = Utils.createURI(baseUri, PageTranslationHistoryResource.class, doc.getWiki(), spaces, doc.getName(), language).toString();
            Link historyLink = this.objectFactory.createLink();
            historyLink.setHref(historyUri);
            historyLink.setRel("http://www.xwiki.org/rel/history");
            translation.getLinks().add(historyLink);
            translations.getTranslations().add(translation);
        }
        return translations;
    }

    private void toRestPageSummary(PageSummary pageSummary, URI baseUri, Document doc, boolean useVersion, Boolean withPrettyNames) throws XWikiException {
        Object tagsObject;
        boolean parentExist;
        XWikiContext xwikiContext = (XWikiContext)this.xcontextProvider.get();
        pageSummary.setWiki(doc.getWiki());
        pageSummary.setFullName(doc.getFullName());
        pageSummary.setId(doc.getPrefixedFullName());
        pageSummary.setSpace(doc.getSpace());
        pageSummary.setName(doc.getName());
        pageSummary.setTitle(doc.getDisplayTitle());
        pageSummary.setXwikiRelativeUrl(doc.getURL("view"));
        pageSummary.setXwikiAbsoluteUrl(doc.getExternalURL("view"));
        pageSummary.setTranslations(this.toRestTranslations(baseUri, doc));
        pageSummary.setSyntax(doc.getSyntax().toIdString());
        pageSummary.setVersion(doc.getVersion());
        pageSummary.setAuthor(doc.getAuthor());
        if (withPrettyNames.booleanValue()) {
            pageSummary.setAuthorName(xwikiContext.getWiki().getUserName(doc.getAuthor(), null, false, xwikiContext));
        }
        pageSummary.setParent(doc.getParent());
        DocumentReference parentReference = doc.getParentReference();
        boolean bl = parentExist = parentReference != null && xwikiContext.getWiki().exists(parentReference, xwikiContext);
        if (parentExist) {
            pageSummary.setParentId((String)this.serializer.serialize((EntityReference)parentReference, new java.lang.Object[0]));
        } else {
            pageSummary.setParentId("");
        }
        List<String> spaces = Utils.getSpacesFromSpaceId(doc.getSpace());
        String spaceUri = Utils.createURI(baseUri, SpaceResource.class, doc.getWiki(), spaces).toString();
        Link spaceLink = this.objectFactory.createLink();
        spaceLink.setHref(spaceUri);
        spaceLink.setRel("http://www.xwiki.org/rel/space");
        pageSummary.getLinks().add(spaceLink);
        if (parentExist) {
            String parentUri = Utils.createURI(baseUri, PageResource.class, parentReference.getWikiReference().getName(), spaces, parentReference.getName()).toString();
            Link parentLink = this.objectFactory.createLink();
            parentLink.setHref(parentUri);
            parentLink.setRel("http://www.xwiki.org/rel/parent");
            pageSummary.getLinks().add(parentLink);
        }
        String historyUri = Utils.createURI(baseUri, PageHistoryResource.class, doc.getWiki(), Utils.getSpacesFromSpaceId(doc.getSpace()), doc.getName()).toString();
        Link historyLink = this.objectFactory.createLink();
        historyLink.setHref(historyUri);
        historyLink.setRel("http://www.xwiki.org/rel/history");
        pageSummary.getLinks().add(historyLink);
        if (!doc.getChildren().isEmpty()) {
            String pageChildrenUri = Utils.createURI(baseUri, PageChildrenResource.class, doc.getWiki(), spaces, doc.getName()).toString();
            Link pageChildrenLink = this.objectFactory.createLink();
            pageChildrenLink.setHref(pageChildrenUri);
            pageChildrenLink.setRel("http://www.xwiki.org/rel/children");
            pageSummary.getLinks().add(pageChildrenLink);
        }
        if (!doc.getComments().isEmpty()) {
            String commentsUri = useVersion ? Utils.createURI(baseUri, CommentsVersionResource.class, doc.getWiki(), spaces, doc.getName(), doc.getVersion()).toString() : Utils.createURI(baseUri, CommentsResource.class, doc.getWiki(), spaces, doc.getName()).toString();
            Link commentsLink = this.objectFactory.createLink();
            commentsLink.setHref(commentsUri);
            commentsLink.setRel("http://www.xwiki.org/rel/comments");
            pageSummary.getLinks().add(commentsLink);
        }
        if (!doc.getAttachmentList().isEmpty()) {
            String attachmentsUri = useVersion ? Utils.createURI(baseUri, AttachmentsAtPageVersionResource.class, doc.getWiki(), spaces, doc.getName(), doc.getVersion()).toString() : Utils.createURI(baseUri, AttachmentsResource.class, doc.getWiki(), spaces, doc.getName()).toString();
            Link attachmentsLink = this.objectFactory.createLink();
            attachmentsLink.setHref(attachmentsUri);
            attachmentsLink.setRel("http://www.xwiki.org/rel/attachments");
            pageSummary.getLinks().add(attachmentsLink);
        }
        if (!doc.getxWikiObjects().keySet().isEmpty()) {
            String objectsUri = useVersion ? Utils.createURI(baseUri, ObjectsAtPageVersionResource.class, doc.getWiki(), spaces, doc.getName(), doc.getVersion()).toString() : Utils.createURI(baseUri, ObjectsResource.class, doc.getWiki(), spaces, doc.getName()).toString();
            Link objectsLink = this.objectFactory.createLink();
            objectsLink.setHref(objectsUri);
            objectsLink.setRel("http://www.xwiki.org/rel/objects");
            pageSummary.getLinks().add(objectsLink);
        }
        if ((tagsObject = doc.getObject("XWiki.TagClass", 0)) != null && tagsObject.getProperty("tags") != null) {
            String tagsUri = Utils.createURI(baseUri, PageTagsResource.class, doc.getWiki(), spaces, doc.getName()).toString();
            Link tagsLink = this.objectFactory.createLink();
            tagsLink.setHref(tagsUri);
            tagsLink.setRel("http://www.xwiki.org/rel/tags");
            pageSummary.getLinks().add(tagsLink);
        }
        String syntaxesUri = Utils.createURI(baseUri, SyntaxesResource.class, new java.lang.Object[0]).toString();
        Link syntaxesLink = this.objectFactory.createLink();
        syntaxesLink.setHref(syntaxesUri);
        syntaxesLink.setRel("http://www.xwiki.org/rel/syntaxes");
        pageSummary.getLinks().add(syntaxesLink);
    }

    public PageSummary toRestPageSummary(URI baseUri, Document doc, Boolean withPrettyNames) throws XWikiException {
        PageSummary pageSummary = this.objectFactory.createPageSummary();
        this.toRestPageSummary(pageSummary, baseUri, doc, false, withPrettyNames);
        String pageUri = Utils.createURI(baseUri, PageResource.class, doc.getWiki(), Utils.getSpacesFromSpaceId(doc.getSpace()), doc.getName()).toString();
        Link pageLink = this.objectFactory.createLink();
        pageLink.setHref(pageUri);
        pageLink.setRel("http://www.xwiki.org/rel/page");
        pageSummary.getLinks().add(pageLink);
        return pageSummary;
    }

    public Page toRestPage(URI baseUri, URI self, Document doc, boolean useVersion, Boolean withPrettyNames, Boolean withObjects, Boolean withXClass, Boolean withAttachments) throws XWikiException {
        Class xwikiClass;
        Page page = this.objectFactory.createPage();
        this.toRestPageSummary((PageSummary)page, baseUri, doc, useVersion, withPrettyNames);
        XWikiContext xwikiContext = (XWikiContext)this.xcontextProvider.get();
        page.setMajorVersion(doc.getRCSVersion().at(0));
        page.setMinorVersion(doc.getRCSVersion().at(1));
        page.setHidden(doc.isHidden());
        page.setLanguage(doc.getLocale().toString());
        page.setCreator(doc.getCreator());
        if (withPrettyNames.booleanValue()) {
            page.setCreatorName(xwikiContext.getWiki().getUserName(doc.getCreator(), null, false, xwikiContext));
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(doc.getCreationDate());
        page.setCreated(calendar);
        page.setModifier(doc.getContentAuthor());
        if (withPrettyNames.booleanValue()) {
            page.setModifierName(xwikiContext.getWiki().getUserName(doc.getContentAuthor(), null, false, xwikiContext));
        }
        calendar = Calendar.getInstance();
        calendar.setTime(doc.getContentUpdateDate());
        page.setModified(calendar);
        page.setComment(doc.getComment());
        page.setContent(doc.getContent());
        if (self != null) {
            Link pageLink = this.objectFactory.createLink();
            pageLink.setHref(self.toString());
            pageLink.setRel("self");
            page.getLinks().add(pageLink);
        }
        if ((xwikiClass = doc.getxWikiClass()) != null) {
            String classUri = Utils.createURI(baseUri, ClassResource.class, doc.getWiki(), xwikiClass.getName()).toString();
            Link classLink = this.objectFactory.createLink();
            classLink.setHref(classUri);
            classLink.setRel("http://www.xwiki.org/rel/class");
            page.getLinks().add(classLink);
        }
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        if (withAttachments.booleanValue()) {
            page.setAttachments(this.objectFactory.createAttachments());
            for (Attachment attachment : doc.getAttachmentList()) {
                URL url = xcontext.getURLFactory().createAttachmentURL(attachment.getFilename(), doc.getSpace(), doc.getName(), "download", null, doc.getWiki(), xcontext);
                String attachmentXWikiAbsoluteUrl = url.toString();
                String attachmentXWikiRelativeUrl = xcontext.getURLFactory().getURL(url, xcontext);
                page.getAttachments().getAttachments().add(this.toRestAttachment(baseUri, attachment, attachmentXWikiRelativeUrl, attachmentXWikiAbsoluteUrl, withPrettyNames, false));
            }
        }
        if (withObjects.booleanValue()) {
            page.setObjects(this.objectFactory.createObjects());
            XWikiDocument xwikiDocument = xcontext.getWiki().getDocument(doc.getDocumentReference(), xcontext);
            for (List objects : xwikiDocument.getXObjects().values()) {
                for (BaseObject object : objects) {
                    page.getObjects().getObjectSummaries().add(this.toRestObject(baseUri, doc, object, false, withPrettyNames));
                }
            }
        }
        if (withXClass.booleanValue()) {
            page.setClazz(this.toRestClass(baseUri, doc.getxWikiClass()));
        }
        return page;
    }

    public org.xwiki.rest.model.jaxb.Class toRestClass(URI baseUri, Class xwikiClass) {
        org.xwiki.rest.model.jaxb.Class clazz = this.objectFactory.createClass();
        clazz.setId(xwikiClass.getName());
        clazz.setName(xwikiClass.getName());
        DocumentReference reference = xwikiClass.getReference();
        String wikiName = reference.getWikiReference().getName();
        for (Element xwikiPropertyClassObject : xwikiClass.getProperties()) {
            com.xpn.xwiki.api.PropertyClass xwikiPropertyClass = (com.xpn.xwiki.api.PropertyClass)xwikiPropertyClassObject;
            org.xwiki.rest.model.jaxb.Property property = this.objectFactory.createProperty();
            property.setName(xwikiPropertyClass.getName());
            property.setType(xwikiPropertyClass.getxWikiClass().getName());
            for (Element xwikiPropertyObject : xwikiPropertyClass.getProperties()) {
                Property xwikiProperty = (Property)xwikiPropertyObject;
                java.lang.Object value = xwikiProperty.getValue();
                Attribute attribute = this.objectFactory.createAttribute();
                attribute.setName(xwikiProperty.getName());
                if (value != null) {
                    attribute.setValue(value.toString());
                } else {
                    attribute.setValue("");
                }
                property.getAttributes().add(attribute);
            }
            String propertyUri = Utils.createURI(baseUri, ClassPropertyResource.class, wikiName, xwikiClass.getName(), xwikiPropertyClass.getName()).toString();
            Link propertyLink = this.objectFactory.createLink();
            propertyLink.setHref(propertyUri);
            propertyLink.setRel("self");
            property.getLinks().add(propertyLink);
            clazz.getProperties().add(property);
        }
        String classUri = Utils.createURI(baseUri, ClassResource.class, wikiName, xwikiClass.getName()).toString();
        Link classLink = this.objectFactory.createLink();
        classLink.setHref(classUri);
        classLink.setRel("self");
        clazz.getLinks().add(classLink);
        String propertiesUri = Utils.createURI(baseUri, ClassPropertiesResource.class, wikiName, xwikiClass.getName()).toString();
        Link propertyLink = this.objectFactory.createLink();
        propertyLink.setHref(propertiesUri);
        propertyLink.setRel("http://www.xwiki.org/rel/properties");
        clazz.getLinks().add(propertyLink);
        String objectsUri = Utils.createURI(baseUri, AllObjectsForClassNameResource.class, wikiName, xwikiClass.getName()).toString();
        Link objectsLink = this.objectFactory.createLink();
        objectsLink.setHref(objectsUri);
        objectsLink.setRel("http://www.xwiki.org/rel/objects");
        clazz.getLinks().add(objectsLink);
        return clazz;
    }

    public org.xwiki.rest.model.jaxb.Attachment toRestAttachment(URI baseUri, Attachment xwikiAttachment, String xwikiRelativeUrl, String xwikiAbsoluteUrl, Boolean withPrettyNames, boolean versionURL) {
        org.xwiki.rest.model.jaxb.Attachment attachment = this.objectFactory.createAttachment();
        Document doc = xwikiAttachment.getDocument();
        attachment.setId(String.format("%s@%s", doc.getPrefixedFullName(), xwikiAttachment.getFilename()));
        attachment.setName(xwikiAttachment.getFilename());
        attachment.setSize(xwikiAttachment.getFilesize());
        attachment.setVersion(xwikiAttachment.getVersion());
        attachment.setPageId(doc.getPrefixedFullName());
        attachment.setPageVersion(doc.getVersion());
        attachment.setMimeType(xwikiAttachment.getMimeType());
        attachment.setAuthor(xwikiAttachment.getAuthor());
        if (withPrettyNames.booleanValue()) {
            XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
            attachment.setAuthorName(xcontext.getWiki().getUserName(xwikiAttachment.getAuthor(), null, false, xcontext));
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(xwikiAttachment.getDate());
        attachment.setDate(calendar);
        attachment.setXwikiRelativeUrl(xwikiRelativeUrl);
        attachment.setXwikiAbsoluteUrl(xwikiAbsoluteUrl);
        String pageUri = Utils.createURI(baseUri, PageResource.class, doc.getWiki(), Utils.getSpacesFromSpaceId(doc.getSpace()), doc.getName()).toString();
        Link pageLink = this.objectFactory.createLink();
        pageLink.setHref(pageUri);
        pageLink.setRel("http://www.xwiki.org/rel/page");
        attachment.getLinks().add(pageLink);
        String attachmentUri = versionURL ? Utils.createURI(baseUri, AttachmentVersionResource.class, doc.getWiki(), Utils.getSpacesFromSpaceId(doc.getSpace()), doc.getName(), xwikiAttachment.getFilename(), xwikiAttachment.getVersion()).toString() : Utils.createURI(baseUri, AttachmentResource.class, doc.getWiki(), Utils.getSpacesFromSpaceId(doc.getSpace()), doc.getName(), xwikiAttachment.getFilename()).toString();
        Link attachmentLink = this.objectFactory.createLink();
        attachmentLink.setHref(attachmentUri);
        attachmentLink.setRel("http://www.xwiki.org/rel/attachmentData");
        attachment.getLinks().add(attachmentLink);
        return attachment;
    }

    private static String serializePropertyValue(PropertyInterface property) {
        if (property == null) {
            return "";
        }
        java.lang.Object value = ((BaseProperty)property).getValue();
        if (value instanceof List) {
            return StringUtils.join((Iterable)((List)value), (String)"|");
        }
        if (value != null) {
            return value.toString();
        }
        return "";
    }
}

